/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSubnetGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSubnetGroupRequest> {
    private final String subnetGroupName;
    private final String description;
    private final List<String> subnetIds;

    private UpdateSubnetGroupRequest(BuilderImpl builder) {
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
    }

    public String subnetGroupName() {
        return this.subnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetGroupName() == null ? 0 : this.subnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubnetGroupRequest)) {
            return false;
        }
        UpdateSubnetGroupRequest other = (UpdateSubnetGroupRequest)((Object)obj);
        if (other.subnetGroupName() == null ^ this.subnetGroupName() == null) {
            return false;
        }
        if (other.subnetGroupName() != null && !other.subnetGroupName().equals(this.subnetGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        return other.subnetIds() == null || other.subnetIds().equals(this.subnetIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetGroupName() != null) {
            sb.append("SubnetGroupName: ").append(this.subnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String subnetGroupName;
        private String description;
        private List<String> subnetIds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubnetGroupRequest model) {
            this.setSubnetGroupName(model.subnetGroupName);
            this.setDescription(model.description);
            this.setSubnetIds(model.subnetIds);
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new ArrayList<String>(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new ArrayList<String>(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
        }

        public UpdateSubnetGroupRequest build() {
            return new UpdateSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSubnetGroupRequest> {
        public Builder subnetGroupName(String var1);

        public Builder description(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

