/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.SecurityGroupIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateClusterRequest> {
    private final String clusterName;
    private final String description;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String notificationTopicStatus;
    private final String parameterGroupName;
    private final List<String> securityGroupIds;

    private UpdateClusterRequest(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.parameterGroupName = builder.parameterGroupName;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String description() {
        return this.description;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterName() == null ? 0 : this.clusterName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicArn() == null ? 0 : this.notificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicStatus() == null ? 0 : this.notificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.parameterGroupName() == null ? 0 : this.parameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest)((Object)obj);
        if (other.clusterName() == null ^ this.clusterName() == null) {
            return false;
        }
        if (other.clusterName() != null && !other.clusterName().equals(this.clusterName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.notificationTopicArn() == null ^ this.notificationTopicArn() == null) {
            return false;
        }
        if (other.notificationTopicArn() != null && !other.notificationTopicArn().equals(this.notificationTopicArn())) {
            return false;
        }
        if (other.notificationTopicStatus() == null ^ this.notificationTopicStatus() == null) {
            return false;
        }
        if (other.notificationTopicStatus() != null && !other.notificationTopicStatus().equals(this.notificationTopicStatus())) {
            return false;
        }
        if (other.parameterGroupName() == null ^ this.parameterGroupName() == null) {
            return false;
        }
        if (other.parameterGroupName() != null && !other.parameterGroupName().equals(this.parameterGroupName())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        return other.securityGroupIds() == null || other.securityGroupIds().equals(this.securityGroupIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName() != null) {
            sb.append("ClusterName: ").append(this.clusterName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.notificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.notificationTopicArn()).append(",");
        }
        if (this.notificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: ").append(this.notificationTopicStatus()).append(",");
        }
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String description;
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String notificationTopicStatus;
        private String parameterGroupName;
        private List<String> securityGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            this.setClusterName(model.clusterName);
            this.setDescription(model.description);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setNotificationTopicArn(model.notificationTopicArn);
            this.setNotificationTopicStatus(model.notificationTopicStatus);
            this.setParameterGroupName(model.parameterGroupName);
            this.setSecurityGroupIds(model.securityGroupIds);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdentifierListCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
        }

        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder description(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder parameterGroupName(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

