/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Subnet;
import software.amazon.awssdk.services.dax.model.SubnetListCopier;
import software.amazon.awssdk.services.dax.transform.SubnetGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubnetGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, SubnetGroup> {
    private final String subnetGroupName;
    private final String description;
    private final String vpcId;
    private final List<Subnet> subnets;

    private SubnetGroup(BuilderImpl builder) {
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
    }

    public String subnetGroupName() {
        return this.subnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetGroupName() == null ? 0 : this.subnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetGroup)) {
            return false;
        }
        SubnetGroup other = (SubnetGroup)obj;
        if (other.subnetGroupName() == null ^ this.subnetGroupName() == null) {
            return false;
        }
        if (other.subnetGroupName() != null && !other.subnetGroupName().equals(this.subnetGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetGroupName() != null) {
            sb.append("SubnetGroupName: ").append(this.subnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubnetGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String subnetGroupName;
        private String description;
        private String vpcId;
        private List<Subnet> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetGroup model) {
            this.setSubnetGroupName(model.subnetGroupName);
            this.setDescription(model.description);
            this.setVpcId(model.vpcId);
            this.setSubnets(model.subnets);
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Subnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<Subnet>(subnets.length);
            }
            for (Subnet e : subnets) {
                this.subnets.add(e);
            }
            return this;
        }

        public final void setSubnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(Subnet ... subnets) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<Subnet>(subnets.length);
            }
            for (Subnet e : subnets) {
                this.subnets.add(e);
            }
        }

        public SubnetGroup build() {
            return new SubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubnetGroup> {
        public Builder subnetGroupName(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);
    }
}

