/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The subscribed user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedUser implements SdkPojo, Serializable, ToCopyableBuilder<SubscribedUser.Builder, SubscribedUser> {
    private static final SdkField<UserProfileDetails> DETAILS_FIELD = SdkField
            .<UserProfileDetails> builder(MarshallingType.SDK_POJO).memberName("details").getter(getter(SubscribedUser::details))
            .setter(setter(Builder::details)).constructor(UserProfileDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SubscribedUser::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UserProfileDetails details;

    private final String id;

    private SubscribedUser(BuilderImpl builder) {
        this.details = builder.details;
        this.id = builder.id;
    }

    /**
     * <p>
     * The subscribed user details.
     * </p>
     * 
     * @return The subscribed user details.
     */
    public final UserProfileDetails details() {
        return details;
    }

    /**
     * <p>
     * The ID of the subscribed user.
     * </p>
     * 
     * @return The ID of the subscribed user.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedUser)) {
            return false;
        }
        SubscribedUser other = (SubscribedUser) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedUser").add("Details", details()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("details", DETAILS_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedUser, T> g) {
        return obj -> g.apply((SubscribedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedUser> {
        /**
         * <p>
         * The subscribed user details.
         * </p>
         * 
         * @param details
         *        The subscribed user details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(UserProfileDetails details);

        /**
         * <p>
         * The subscribed user details.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserProfileDetails.Builder} avoiding the
         * need to create one manually via {@link UserProfileDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserProfileDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(UserProfileDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link UserProfileDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(UserProfileDetails)
         */
        default Builder details(Consumer<UserProfileDetails.Builder> details) {
            return details(UserProfileDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The ID of the subscribed user.
         * </p>
         * 
         * @param id
         *        The ID of the subscribed user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private UserProfileDetails details;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedUser model) {
            details(model.details);
            id(model.id);
        }

        public final UserProfileDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(UserProfileDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(UserProfileDetails details) {
            this.details = details;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public SubscribedUser build() {
            return new SubscribedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
