/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The principal that has the subscription grant for the asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedPrincipal.Builder, SubscribedPrincipal> {
    private static final SdkField<SubscribedGroup> GROUP_FIELD = SdkField.<SubscribedGroup> builder(MarshallingType.SDK_POJO)
            .memberName("group").getter(getter(SubscribedPrincipal::group)).setter(setter(Builder::group))
            .constructor(SubscribedGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<SubscribedProject> PROJECT_FIELD = SdkField
            .<SubscribedProject> builder(MarshallingType.SDK_POJO).memberName("project")
            .getter(getter(SubscribedPrincipal::project)).setter(setter(Builder::project))
            .constructor(SubscribedProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final SdkField<SubscribedUser> USER_FIELD = SdkField.<SubscribedUser> builder(MarshallingType.SDK_POJO)
            .memberName("user").getter(getter(SubscribedPrincipal::user)).setter(setter(Builder::user))
            .constructor(SubscribedUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, PROJECT_FIELD,
            USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SubscribedGroup group;

    private final SubscribedProject project;

    private final SubscribedUser user;

    private final Type type;

    private SubscribedPrincipal(BuilderImpl builder) {
        this.group = builder.group;
        this.project = builder.project;
        this.user = builder.user;
        this.type = builder.type;
    }

    /**
     * <p>
     * The subscribed group.
     * </p>
     * 
     * @return The subscribed group.
     */
    public final SubscribedGroup group() {
        return group;
    }

    /**
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @return The project that has the subscription grant.
     */
    public final SubscribedProject project() {
        return project;
    }

    /**
     * <p>
     * The subscribed user.
     * </p>
     * 
     * @return The subscribed user.
     */
    public final SubscribedUser user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipal)) {
            return false;
        }
        SubscribedPrincipal other = (SubscribedPrincipal) obj;
        return Objects.equals(group(), other.group()) && Objects.equals(project(), other.project())
                && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedPrincipal").add("Group", group()).add("Project", project()).add("User", user())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The subscribed group.
     * </p>
     * 
     * @param group
     *        The subscribed group.
     */
    public static SubscribedPrincipal fromGroup(SubscribedGroup group) {
        return builder().group(group).build();
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * The subscribed group.
     * </p>
     * 
     * @param group
     *        The subscribed group.
     */
    public static SubscribedPrincipal fromGroup(Consumer<SubscribedGroup.Builder> group) {
        SubscribedGroup.Builder builder = SubscribedGroup.builder();
        group.accept(builder);
        return fromGroup(builder.build());
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @param project
     *        The project that has the subscription grant.
     */
    public static SubscribedPrincipal fromProject(SubscribedProject project) {
        return builder().project(project).build();
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @param project
     *        The project that has the subscription grant.
     */
    public static SubscribedPrincipal fromProject(Consumer<SubscribedProject.Builder> project) {
        SubscribedProject.Builder builder = SubscribedProject.builder();
        project.accept(builder);
        return fromProject(builder.build());
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The subscribed user.
     * </p>
     * 
     * @param user
     *        The subscribed user.
     */
    public static SubscribedPrincipal fromUser(SubscribedUser user) {
        return builder().user(user).build();
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * The subscribed user.
     * </p>
     * 
     * @param user
     *        The subscribed user.
     */
    public static SubscribedPrincipal fromUser(Consumer<SubscribedUser.Builder> user) {
        SubscribedUser.Builder builder = SubscribedUser.builder();
        user.accept(builder);
        return fromUser(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("group", GROUP_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipal, T> g) {
        return obj -> g.apply((SubscribedPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedPrincipal> {
        /**
         * <p>
         * The subscribed group.
         * </p>
         * 
         * @param group
         *        The subscribed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(SubscribedGroup group);

        /**
         * <p>
         * The subscribed group.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedGroup.Builder} avoiding the
         * need to create one manually via {@link SubscribedGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #group(SubscribedGroup)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link SubscribedGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(SubscribedGroup)
         */
        default Builder group(Consumer<SubscribedGroup.Builder> group) {
            return group(SubscribedGroup.builder().applyMutation(group).build());
        }

        /**
         * <p>
         * The project that has the subscription grant.
         * </p>
         * 
         * @param project
         *        The project that has the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(SubscribedProject project);

        /**
         * <p>
         * The project that has the subscription grant.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedProject.Builder} avoiding the
         * need to create one manually via {@link SubscribedProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedProject.Builder#build()} is called immediately and its
         * result is passed to {@link #project(SubscribedProject)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link SubscribedProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(SubscribedProject)
         */
        default Builder project(Consumer<SubscribedProject.Builder> project) {
            return project(SubscribedProject.builder().applyMutation(project).build());
        }

        /**
         * <p>
         * The subscribed user.
         * </p>
         * 
         * @param user
         *        The subscribed user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(SubscribedUser user);

        /**
         * <p>
         * The subscribed user.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedUser.Builder} avoiding the need
         * to create one manually via {@link SubscribedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedUser.Builder#build()} is called immediately and its
         * result is passed to {@link #user(SubscribedUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link SubscribedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(SubscribedUser)
         */
        default Builder user(Consumer<SubscribedUser.Builder> user) {
            return user(SubscribedUser.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SubscribedGroup group;

        private SubscribedProject project;

        private SubscribedUser user;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipal model) {
            group(model.group);
            project(model.project);
            user(model.user);
        }

        public final SubscribedGroup.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(SubscribedGroup.BuilderImpl group) {
            Object oldValue = this.group;
            this.group = group != null ? group.build() : null;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(SubscribedGroup group) {
            Object oldValue = this.group;
            this.group = group;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final SubscribedProject.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(SubscribedProject.BuilderImpl project) {
            Object oldValue = this.project;
            this.project = project != null ? project.build() : null;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProject project) {
            Object oldValue = this.project;
            this.project = project;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public final SubscribedUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(SubscribedUser.BuilderImpl user) {
            Object oldValue = this.user;
            this.user = user != null ? user.build() : null;
            handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(SubscribedUser user) {
            Object oldValue = this.user;
            this.user = user;
            handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public SubscribedPrincipal build() {
            return new SubscribedPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SubscribedPrincipal#type()
     */
    public enum Type {
        GROUP,

        PROJECT,

        USER,

        UNKNOWN_TO_SDK_VERSION
    }
}
