/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataExportConfigurationRequest extends DataZoneRequest implements
        ToCopyableBuilder<PutDataExportConfigurationRequest.Builder, PutDataExportConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutDataExportConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(PutDataExportConfigurationRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Boolean> ENABLE_EXPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExport").getter(getter(PutDataExportConfigurationRequest::enableExport))
            .setter(setter(Builder::enableExport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExport").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(PutDataExportConfigurationRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENABLE_EXPORT_FIELD, ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String domainIdentifier;

    private final Boolean enableExport;

    private final EncryptionConfiguration encryptionConfiguration;

    private PutDataExportConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.enableExport = builder.enableExport;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *         populated if not provided.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The domain ID where you want to create data export configuration details.
     * </p>
     * 
     * @return The domain ID where you want to create data export configuration details.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies that the export is to be enabled as part of creating data export configuration details.
     * </p>
     * 
     * @return Specifies that the export is to be enabled as part of creating data export configuration details.
     */
    public final Boolean enableExport() {
        return enableExport;
    }

    /**
     * <p>
     * The encryption configuration as part of creating data export configuration details.
     * </p>
     * <p>
     * The KMS key provided here as part of encryptionConfiguration must have the required permissions as described in
     * <a href=
     * "https://docs.aws.amazon.com/sagemaker-unified-studio/latest/adminguide/sagemaker-unified-studio-export-asset-metadata-kms-permissions.html"
     * >KMS permissions for exporting asset metadata in Amazon SageMaker Unified Studio</a>.
     * </p>
     * 
     * @return The encryption configuration as part of creating data export configuration details.</p>
     *         <p>
     *         The KMS key provided here as part of encryptionConfiguration must have the required permissions as
     *         described in <a href=
     *         "https://docs.aws.amazon.com/sagemaker-unified-studio/latest/adminguide/sagemaker-unified-studio-export-asset-metadata-kms-permissions.html"
     *         >KMS permissions for exporting asset metadata in Amazon SageMaker Unified Studio</a>.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(enableExport());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataExportConfigurationRequest)) {
            return false;
        }
        PutDataExportConfigurationRequest other = (PutDataExportConfigurationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(enableExport(), other.enableExport())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataExportConfigurationRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("EnableExport", enableExport())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "enableExport":
            return Optional.ofNullable(clazz.cast(enableExport()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("enableExport", ENABLE_EXPORT_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataExportConfigurationRequest, T> g) {
        return obj -> g.apply((PutDataExportConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataExportConfigurationRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         * populated if not provided.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         *        populated if not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The domain ID where you want to create data export configuration details.
         * </p>
         * 
         * @param domainIdentifier
         *        The domain ID where you want to create data export configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies that the export is to be enabled as part of creating data export configuration details.
         * </p>
         * 
         * @param enableExport
         *        Specifies that the export is to be enabled as part of creating data export configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExport(Boolean enableExport);

        /**
         * <p>
         * The encryption configuration as part of creating data export configuration details.
         * </p>
         * <p>
         * The KMS key provided here as part of encryptionConfiguration must have the required permissions as described
         * in <a href=
         * "https://docs.aws.amazon.com/sagemaker-unified-studio/latest/adminguide/sagemaker-unified-studio-export-asset-metadata-kms-permissions.html"
         * >KMS permissions for exporting asset metadata in Amazon SageMaker Unified Studio</a>.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration as part of creating data export configuration details.</p>
         *        <p>
         *        The KMS key provided here as part of encryptionConfiguration must have the required permissions as
         *        described in <a href=
         *        "https://docs.aws.amazon.com/sagemaker-unified-studio/latest/adminguide/sagemaker-unified-studio-export-asset-metadata-kms-permissions.html"
         *        >KMS permissions for exporting asset metadata in Amazon SageMaker Unified Studio</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration as part of creating data export configuration details.
         * </p>
         * <p>
         * The KMS key provided here as part of encryptionConfiguration must have the required permissions as described
         * in <a href=
         * "https://docs.aws.amazon.com/sagemaker-unified-studio/latest/adminguide/sagemaker-unified-studio-export-asset-metadata-kms-permissions.html"
         * >KMS permissions for exporting asset metadata in Amazon SageMaker Unified Studio</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private Boolean enableExport;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataExportConfigurationRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            enableExport(model.enableExport);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Boolean getEnableExport() {
            return enableExport;
        }

        public final void setEnableExport(Boolean enableExport) {
            this.enableExport = enableExport;
        }

        @Override
        public final Builder enableExport(Boolean enableExport) {
            this.enableExport = enableExport;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataExportConfigurationRequest build() {
            return new PutDataExportConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
