/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The physical endpoints of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalEndpoint.Builder, PhysicalEndpoint> {
    private static final SdkField<AwsLocation> AWS_LOCATION_FIELD = SdkField.<AwsLocation> builder(MarshallingType.SDK_POJO)
            .memberName("awsLocation").getter(getter(PhysicalEndpoint::awsLocation)).setter(setter(Builder::awsLocation))
            .constructor(AwsLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLocation").build()).build();

    private static final SdkField<Boolean> ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrustedIdentityPropagation")
            .getter(getter(PhysicalEndpoint::enableTrustedIdentityPropagation))
            .setter(setter(Builder::enableTrustedIdentityPropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrustedIdentityPropagation")
                    .build()).build();

    private static final SdkField<GlueConnection> GLUE_CONNECTION_FIELD = SdkField
            .<GlueConnection> builder(MarshallingType.SDK_POJO).memberName("glueConnection")
            .getter(getter(PhysicalEndpoint::glueConnection)).setter(setter(Builder::glueConnection))
            .constructor(GlueConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnection").build()).build();

    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueConnectionName").getter(getter(PhysicalEndpoint::glueConnectionName))
            .setter(setter(Builder::glueConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionName").build())
            .build();

    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("host")
            .getter(getter(PhysicalEndpoint::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(PhysicalEndpoint::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(PhysicalEndpoint::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(PhysicalEndpoint::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOCATION_FIELD,
            ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD, GLUE_CONNECTION_FIELD, GLUE_CONNECTION_NAME_FIELD, HOST_FIELD, PORT_FIELD,
            PROTOCOL_FIELD, STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsLocation awsLocation;

    private final Boolean enableTrustedIdentityPropagation;

    private final GlueConnection glueConnection;

    private final String glueConnectionName;

    private final String host;

    private final Integer port;

    private final String protocol;

    private final String stage;

    private PhysicalEndpoint(BuilderImpl builder) {
        this.awsLocation = builder.awsLocation;
        this.enableTrustedIdentityPropagation = builder.enableTrustedIdentityPropagation;
        this.glueConnection = builder.glueConnection;
        this.glueConnectionName = builder.glueConnectionName;
        this.host = builder.host;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The location of a connection.
     * </p>
     * 
     * @return The location of a connection.
     */
    public final AwsLocation awsLocation() {
        return awsLocation;
    }

    /**
     * <p>
     * Specified whether trusted identity propagation for the connection is enabled.
     * </p>
     * 
     * @return Specified whether trusted identity propagation for the connection is enabled.
     */
    public final Boolean enableTrustedIdentityPropagation() {
        return enableTrustedIdentityPropagation;
    }

    /**
     * <p>
     * The Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The Amazon Web Services Glue connection.
     */
    public final GlueConnection glueConnection() {
        return glueConnection;
    }

    /**
     * <p>
     * The Amazon Web Services Glue connection name.
     * </p>
     * 
     * @return The Amazon Web Services Glue connection name.
     */
    public final String glueConnectionName() {
        return glueConnectionName;
    }

    /**
     * <p>
     * The host in the physical endpoints of a connection.
     * </p>
     * 
     * @return The host in the physical endpoints of a connection.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The port in the physical endpoints of a connection.
     * </p>
     * 
     * @return The port in the physical endpoints of a connection.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol in the physical endpoints of a connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol in the physical endpoints of a connection.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol in the physical endpoints of a connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol in the physical endpoints of a connection.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The stage in the physical endpoints of a connection.
     * </p>
     * 
     * @return The stage in the physical endpoints of a connection.
     */
    public final String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrustedIdentityPropagation());
        hashCode = 31 * hashCode + Objects.hashCode(glueConnection());
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalEndpoint)) {
            return false;
        }
        PhysicalEndpoint other = (PhysicalEndpoint) obj;
        return Objects.equals(awsLocation(), other.awsLocation())
                && Objects.equals(enableTrustedIdentityPropagation(), other.enableTrustedIdentityPropagation())
                && Objects.equals(glueConnection(), other.glueConnection())
                && Objects.equals(glueConnectionName(), other.glueConnectionName()) && Objects.equals(host(), other.host())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalEndpoint").add("AwsLocation", awsLocation())
                .add("EnableTrustedIdentityPropagation", enableTrustedIdentityPropagation())
                .add("GlueConnection", glueConnection()).add("GlueConnectionName", glueConnectionName()).add("Host", host())
                .add("Port", port()).add("Protocol", protocolAsString()).add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsLocation":
            return Optional.ofNullable(clazz.cast(awsLocation()));
        case "enableTrustedIdentityPropagation":
            return Optional.ofNullable(clazz.cast(enableTrustedIdentityPropagation()));
        case "glueConnection":
            return Optional.ofNullable(clazz.cast(glueConnection()));
        case "glueConnectionName":
            return Optional.ofNullable(clazz.cast(glueConnectionName()));
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsLocation", AWS_LOCATION_FIELD);
        map.put("enableTrustedIdentityPropagation", ENABLE_TRUSTED_IDENTITY_PROPAGATION_FIELD);
        map.put("glueConnection", GLUE_CONNECTION_FIELD);
        map.put("glueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        map.put("host", HOST_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalEndpoint, T> g) {
        return obj -> g.apply((PhysicalEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalEndpoint> {
        /**
         * <p>
         * The location of a connection.
         * </p>
         * 
         * @param awsLocation
         *        The location of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLocation(AwsLocation awsLocation);

        /**
         * <p>
         * The location of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLocation.Builder} avoiding the need to
         * create one manually via {@link AwsLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #awsLocation(AwsLocation)}.
         * 
         * @param awsLocation
         *        a consumer that will call methods on {@link AwsLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLocation(AwsLocation)
         */
        default Builder awsLocation(Consumer<AwsLocation.Builder> awsLocation) {
            return awsLocation(AwsLocation.builder().applyMutation(awsLocation).build());
        }

        /**
         * <p>
         * Specified whether trusted identity propagation for the connection is enabled.
         * </p>
         * 
         * @param enableTrustedIdentityPropagation
         *        Specified whether trusted identity propagation for the connection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrustedIdentityPropagation(Boolean enableTrustedIdentityPropagation);

        /**
         * <p>
         * The Amazon Web Services Glue connection.
         * </p>
         * 
         * @param glueConnection
         *        The Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnection(GlueConnection glueConnection);

        /**
         * <p>
         * The Amazon Web Services Glue connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueConnection.Builder} avoiding the need
         * to create one manually via {@link GlueConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #glueConnection(GlueConnection)}.
         * 
         * @param glueConnection
         *        a consumer that will call methods on {@link GlueConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueConnection(GlueConnection)
         */
        default Builder glueConnection(Consumer<GlueConnection.Builder> glueConnection) {
            return glueConnection(GlueConnection.builder().applyMutation(glueConnection).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue connection name.
         * </p>
         * 
         * @param glueConnectionName
         *        The Amazon Web Services Glue connection name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionName(String glueConnectionName);

        /**
         * <p>
         * The host in the physical endpoints of a connection.
         * </p>
         * 
         * @param host
         *        The host in the physical endpoints of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The port in the physical endpoints of a connection.
         * </p>
         * 
         * @param port
         *        The port in the physical endpoints of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol in the physical endpoints of a connection.
         * </p>
         * 
         * @param protocol
         *        The protocol in the physical endpoints of a connection.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol in the physical endpoints of a connection.
         * </p>
         * 
         * @param protocol
         *        The protocol in the physical endpoints of a connection.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The stage in the physical endpoints of a connection.
         * </p>
         * 
         * @param stage
         *        The stage in the physical endpoints of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);
    }

    static final class BuilderImpl implements Builder {
        private AwsLocation awsLocation;

        private Boolean enableTrustedIdentityPropagation;

        private GlueConnection glueConnection;

        private String glueConnectionName;

        private String host;

        private Integer port;

        private String protocol;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalEndpoint model) {
            awsLocation(model.awsLocation);
            enableTrustedIdentityPropagation(model.enableTrustedIdentityPropagation);
            glueConnection(model.glueConnection);
            glueConnectionName(model.glueConnectionName);
            host(model.host);
            port(model.port);
            protocol(model.protocol);
            stage(model.stage);
        }

        public final AwsLocation.Builder getAwsLocation() {
            return awsLocation != null ? awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AwsLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AwsLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final Boolean getEnableTrustedIdentityPropagation() {
            return enableTrustedIdentityPropagation;
        }

        public final void setEnableTrustedIdentityPropagation(Boolean enableTrustedIdentityPropagation) {
            this.enableTrustedIdentityPropagation = enableTrustedIdentityPropagation;
        }

        @Override
        public final Builder enableTrustedIdentityPropagation(Boolean enableTrustedIdentityPropagation) {
            this.enableTrustedIdentityPropagation = enableTrustedIdentityPropagation;
            return this;
        }

        public final GlueConnection.Builder getGlueConnection() {
            return glueConnection != null ? glueConnection.toBuilder() : null;
        }

        public final void setGlueConnection(GlueConnection.BuilderImpl glueConnection) {
            this.glueConnection = glueConnection != null ? glueConnection.build() : null;
        }

        @Override
        public final Builder glueConnection(GlueConnection glueConnection) {
            this.glueConnection = glueConnection;
            return this;
        }

        public final String getGlueConnectionName() {
            return glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public PhysicalEndpoint build() {
            return new PhysicalEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
