/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permissions implements SdkPojo, Serializable, ToCopyableBuilder<Permissions.Builder, Permissions> {
    private static final SdkField<List<String>> S3_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("s3")
            .getter(getter(Permissions::s3AsStrings))
            .setter(setter(Builder::s3WithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> s3;

    private final Type type;

    private Permissions(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    /**
     * <p>
     * The S3 details of the asset permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3} method.
     * </p>
     * 
     * @return The S3 details of the asset permissions.
     */
    public final List<S3Permission> s3() {
        return S3PermissionsCopier.copyStringToEnum(s3);
    }

    /**
     * For responses, this returns true if the service returned a value for the S3 property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasS3() {
        return s3 != null && !(s3 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 details of the asset permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3} method.
     * </p>
     * 
     * @return The S3 details of the asset permissions.
     */
    public final List<String> s3AsStrings() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3() ? s3AsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permissions)) {
            return false;
        }
        Permissions other = (Permissions) obj;
        return hasS3() == other.hasS3() && Objects.equals(s3AsStrings(), other.s3AsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Permissions").add("S3", hasS3() ? s3AsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3AsStrings()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3AsStrings()} initialized to the given value.
     *
     * <p>
     * The S3 details of the asset permissions.
     * </p>
     * 
     * @param s3
     *        The S3 details of the asset permissions.
     */
    public static Permissions fromS3WithStrings(List<String> s3WithStrings) {
        return builder().s3WithStrings(s3WithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #s3AsStrings()} initialized to the given value.
     *
     * <p>
     * The S3 details of the asset permissions.
     * </p>
     * 
     * @param s3
     *        The S3 details of the asset permissions.
     */
    public static Permissions fromS3(List<S3Permission> s3WithStrings) {
        return builder().s3(s3WithStrings).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Permissions, T> g) {
        return obj -> g.apply((Permissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permissions> {
        /**
         * <p>
         * The S3 details of the asset permissions.
         * </p>
         * 
         * @param s3
         *        The S3 details of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3WithStrings(Collection<String> s3);

        /**
         * <p>
         * The S3 details of the asset permissions.
         * </p>
         * 
         * @param s3
         *        The S3 details of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3WithStrings(String... s3);

        /**
         * <p>
         * The S3 details of the asset permissions.
         * </p>
         * 
         * @param s3
         *        The S3 details of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(Collection<S3Permission> s3);

        /**
         * <p>
         * The S3 details of the asset permissions.
         * </p>
         * 
         * @param s3
         *        The S3 details of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Permission... s3);
    }

    static final class BuilderImpl implements Builder {
        private List<String> s3 = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Permissions model) {
            s3WithStrings(model.s3);
        }

        public final Collection<String> getS3() {
            if (s3 instanceof SdkAutoConstructList) {
                return null;
            }
            return s3;
        }

        public final void setS3(Collection<String> s3) {
            Object oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copy(s3);
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3WithStrings(Collection<String> s3) {
            Object oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copy(s3);
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3WithStrings(String... s3) {
            s3WithStrings(Arrays.asList(s3));
            return this;
        }

        @Override
        public final Builder s3(Collection<S3Permission> s3) {
            Object oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copyEnumToString(s3);
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(S3Permission... s3) {
            s3(Arrays.asList(s3));
            return this;
        }

        @Override
        public Permissions build() {
            return new Permissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Permissions#type()
     */
    public enum Type {
        S3,

        UNKNOWN_TO_SDK_VERSION
    }
}
