/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The offset of a matched term.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchOffset implements SdkPojo, Serializable, ToCopyableBuilder<MatchOffset.Builder, MatchOffset> {
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endOffset").getter(getter(MatchOffset::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOffset").build()).build();

    private static final SdkField<Integer> START_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startOffset").getter(getter(MatchOffset::startOffset)).setter(setter(Builder::startOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_OFFSET_FIELD,
            START_OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer endOffset;

    private final Integer startOffset;

    private MatchOffset(BuilderImpl builder) {
        this.endOffset = builder.endOffset;
        this.startOffset = builder.startOffset;
    }

    /**
     * <p>
     * The 0-indexed number indicating the end position (exclusive) of a matched term.
     * </p>
     * 
     * @return The 0-indexed number indicating the end position (exclusive) of a matched term.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The 0-indexed number indicating the start position (inclusive) of a matched term.
     * </p>
     * 
     * @return The 0-indexed number indicating the start position (inclusive) of a matched term.
     */
    public final Integer startOffset() {
        return startOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(startOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchOffset)) {
            return false;
        }
        MatchOffset other = (MatchOffset) obj;
        return Objects.equals(endOffset(), other.endOffset()) && Objects.equals(startOffset(), other.startOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchOffset").add("EndOffset", endOffset()).add("StartOffset", startOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "startOffset":
            return Optional.ofNullable(clazz.cast(startOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endOffset", END_OFFSET_FIELD);
        map.put("startOffset", START_OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchOffset, T> g) {
        return obj -> g.apply((MatchOffset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchOffset> {
        /**
         * <p>
         * The 0-indexed number indicating the end position (exclusive) of a matched term.
         * </p>
         * 
         * @param endOffset
         *        The 0-indexed number indicating the end position (exclusive) of a matched term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The 0-indexed number indicating the start position (inclusive) of a matched term.
         * </p>
         * 
         * @param startOffset
         *        The 0-indexed number indicating the start position (inclusive) of a matched term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startOffset(Integer startOffset);
    }

    static final class BuilderImpl implements Builder {
        private Integer endOffset;

        private Integer startOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchOffset model) {
            endOffset(model.endOffset);
            startOffset(model.startOffset);
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final Integer getStartOffset() {
            return startOffset;
        }

        public final void setStartOffset(Integer startOffset) {
            this.startOffset = startOffset;
        }

        @Override
        public final Builder startOffset(Integer startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @Override
        public MatchOffset build() {
            return new MatchOffset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
