/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscriptionGrantsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListSubscriptionGrantsRequest.Builder, ListSubscriptionGrantsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListSubscriptionGrantsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(ListSubscriptionGrantsRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSubscriptionGrantsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubscriptionGrantsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> OWNING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningGroupId").getter(getter(ListSubscriptionGrantsRequest::owningGroupId))
            .setter(setter(Builder::owningGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningGroupId").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(ListSubscriptionGrantsRequest::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningProjectId").build())
            .build();

    private static final SdkField<String> OWNING_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningUserId").getter(getter(ListSubscriptionGrantsRequest::owningUserId))
            .setter(setter(Builder::owningUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningUserId").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListSubscriptionGrantsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListSubscriptionGrantsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final SdkField<String> SUBSCRIBED_LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscribedListingId").getter(getter(ListSubscriptionGrantsRequest::subscribedListingId))
            .setter(setter(Builder::subscribedListingId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscribedListingId").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionId").getter(getter(ListSubscriptionGrantsRequest::subscriptionId))
            .setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscriptionId").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionTargetId").getter(getter(ListSubscriptionGrantsRequest::subscriptionTargetId))
            .setter(setter(Builder::subscriptionTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscriptionTargetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENVIRONMENT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNING_GROUP_ID_FIELD, OWNING_PROJECT_ID_FIELD,
            OWNING_USER_ID_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, SUBSCRIBED_LISTING_ID_FIELD, SUBSCRIPTION_ID_FIELD,
            SUBSCRIPTION_TARGET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String environmentId;

    private final Integer maxResults;

    private final String nextToken;

    private final String owningGroupId;

    private final String owningProjectId;

    private final String owningUserId;

    private final String sortBy;

    private final String sortOrder;

    private final String subscribedListingId;

    private final String subscriptionId;

    private final String subscriptionTargetId;

    private ListSubscriptionGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentId = builder.environmentId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.owningGroupId = builder.owningGroupId;
        this.owningProjectId = builder.owningProjectId;
        this.owningUserId = builder.owningUserId;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.subscribedListingId = builder.subscribedListingId;
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionTargetId = builder.subscriptionTargetId;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone environment.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The maximum number of subscription grants to return in a single call to <code>ListSubscriptionGrants</code>. When
     * the number of subscription grants to be listed is greater than the value of <code>MaxResults</code>, the response
     * contains a <code>NextToken</code> value that you can use in a subsequent call to
     * <code>ListSubscriptionGrants</code> to list the next set of subscription grants.
     * </p>
     * 
     * @return The maximum number of subscription grants to return in a single call to
     *         <code>ListSubscriptionGrants</code>. When the number of subscription grants to be listed is greater than
     *         the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can
     *         use in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of subscription
     *         grants.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of subscription grants is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * subscription grants, the response includes a pagination token named <code>NextToken</code>. You can specify this
     * <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of
     * subscription grants.
     * </p>
     * 
     * @return When the number of subscription grants is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of subscription grants, the response includes a pagination token named <code>NextToken</code>. You can
     *         specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionGrants</code> to
     *         list the next set of subscription grants.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the owning group.
     * </p>
     * 
     * @return The ID of the owning group.
     */
    public final String owningGroupId() {
        return owningGroupId;
    }

    /**
     * <p>
     * The ID of the owning project of the subscription grants.
     * </p>
     * 
     * @return The ID of the owning project of the subscription grants.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The ID of the owning user.
     * </p>
     * 
     * @return The ID of the owning user.
     */
    public final String owningUserId() {
        return owningUserId;
    }

    /**
     * <p>
     * Specifies the way of sorting the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way of sorting the results of this action.
     * @see SortKey
     * @deprecated Results are always sorted by updatedAt
     */
    @Deprecated
    public final SortKey sortBy() {
        return SortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies the way of sorting the results of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the way of sorting the results of this action.
     * @see SortKey
     * @deprecated Results are always sorted by updatedAt
     */
    @Deprecated
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Specifies the sort order of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order of this action.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies the sort order of this action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies the sort order of this action.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The identifier of the subscribed listing.
     * </p>
     * 
     * @return The identifier of the subscribed listing.
     */
    public final String subscribedListingId() {
        return subscribedListingId;
    }

    /**
     * <p>
     * The identifier of the subscription.
     * </p>
     * 
     * @return The identifier of the subscription.
     */
    public final String subscriptionId() {
        return subscriptionId;
    }

    /**
     * <p>
     * The identifier of the subscription target.
     * </p>
     * 
     * @return The identifier of the subscription target.
     */
    public final String subscriptionTargetId() {
        return subscriptionTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(owningGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(owningUserId());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedListingId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionGrantsRequest)) {
            return false;
        }
        ListSubscriptionGrantsRequest other = (ListSubscriptionGrantsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(owningGroupId(), other.owningGroupId())
                && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(owningUserId(), other.owningUserId())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(subscribedListingId(), other.subscribedListingId())
                && Objects.equals(subscriptionId(), other.subscriptionId())
                && Objects.equals(subscriptionTargetId(), other.subscriptionTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscriptionGrantsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentId", environmentId()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OwningGroupId", owningGroupId()).add("OwningProjectId", owningProjectId())
                .add("OwningUserId", owningUserId()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("SubscribedListingId", subscribedListingId()).add("SubscriptionId", subscriptionId())
                .add("SubscriptionTargetId", subscriptionTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "owningGroupId":
            return Optional.ofNullable(clazz.cast(owningGroupId()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "owningUserId":
            return Optional.ofNullable(clazz.cast(owningUserId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "subscribedListingId":
            return Optional.ofNullable(clazz.cast(subscribedListingId()));
        case "subscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        case "subscriptionTargetId":
            return Optional.ofNullable(clazz.cast(subscriptionTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("owningGroupId", OWNING_GROUP_ID_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("owningUserId", OWNING_USER_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("subscribedListingId", SUBSCRIBED_LISTING_ID_FIELD);
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionTargetId", SUBSCRIPTION_TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionGrantsRequest, T> g) {
        return obj -> g.apply((ListSubscriptionGrantsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscriptionGrantsRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the Amazon DataZone environment.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The maximum number of subscription grants to return in a single call to <code>ListSubscriptionGrants</code>.
         * When the number of subscription grants to be listed is greater than the value of <code>MaxResults</code>, the
         * response contains a <code>NextToken</code> value that you can use in a subsequent call to
         * <code>ListSubscriptionGrants</code> to list the next set of subscription grants.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of subscription grants to return in a single call to
         *        <code>ListSubscriptionGrants</code>. When the number of subscription grants to be listed is greater
         *        than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that
         *        you can use in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of
         *        subscription grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of subscription grants is greater than the default value for the <code>MaxResults</code>
         * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * subscription grants, the response includes a pagination token named <code>NextToken</code>. You can specify
         * this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionGrants</code> to list the
         * next set of subscription grants.
         * </p>
         * 
         * @param nextToken
         *        When the number of subscription grants is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of subscription grants, the response includes a pagination token named
         *        <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         *        <code>ListSubscriptionGrants</code> to list the next set of subscription grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the owning group.
         * </p>
         * 
         * @param owningGroupId
         *        The ID of the owning group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningGroupId(String owningGroupId);

        /**
         * <p>
         * The ID of the owning project of the subscription grants.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the owning project of the subscription grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The ID of the owning user.
         * </p>
         * 
         * @param owningUserId
         *        The ID of the owning user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningUserId(String owningUserId);

        /**
         * <p>
         * Specifies the way of sorting the results of this action.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way of sorting the results of this action.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         * @deprecated Results are always sorted by updatedAt
         */
        @Deprecated
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies the way of sorting the results of this action.
         * </p>
         * 
         * @param sortBy
         *        Specifies the way of sorting the results of this action.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         * @deprecated Results are always sorted by updatedAt
         */
        @Deprecated
        Builder sortBy(SortKey sortBy);

        /**
         * <p>
         * Specifies the sort order of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies the sort order of this action.
         * </p>
         * 
         * @param sortOrder
         *        Specifies the sort order of this action.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The identifier of the subscribed listing.
         * </p>
         * 
         * @param subscribedListingId
         *        The identifier of the subscribed listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListingId(String subscribedListingId);

        /**
         * <p>
         * The identifier of the subscription.
         * </p>
         * 
         * @param subscriptionId
         *        The identifier of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionId(String subscriptionId);

        /**
         * <p>
         * The identifier of the subscription target.
         * </p>
         * 
         * @param subscriptionTargetId
         *        The identifier of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetId(String subscriptionTargetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String environmentId;

        private Integer maxResults;

        private String nextToken;

        private String owningGroupId;

        private String owningProjectId;

        private String owningUserId;

        private String sortBy;

        private String sortOrder;

        private String subscribedListingId;

        private String subscriptionId;

        private String subscriptionTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionGrantsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            environmentId(model.environmentId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            owningGroupId(model.owningGroupId);
            owningProjectId(model.owningProjectId);
            owningUserId(model.owningUserId);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            subscribedListingId(model.subscribedListingId);
            subscriptionId(model.subscriptionId);
            subscriptionTargetId(model.subscriptionTargetId);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwningGroupId() {
            return owningGroupId;
        }

        public final void setOwningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
        }

        @Override
        public final Builder owningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getOwningUserId() {
            return owningUserId;
        }

        public final void setOwningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
        }

        @Override
        public final Builder owningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
            return this;
        }

        @Deprecated
        public final String getSortBy() {
            return sortBy;
        }

        @Deprecated
        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Deprecated
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Deprecated
        public final Builder sortBy(SortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSubscribedListingId() {
            return subscribedListingId;
        }

        public final void setSubscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
        }

        @Override
        public final Builder subscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
            return this;
        }

        public final String getSubscriptionId() {
            return subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionTargetId() {
            return subscriptionTargetId;
        }

        public final void setSubscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
        }

        @Override
        public final Builder subscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionGrantsRequest build() {
            return new ListSubscriptionGrantsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
