/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the account/Region that is to be used during project creation for a particular blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentResolvedAccount implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentResolvedAccount.Builder, EnvironmentResolvedAccount> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(EnvironmentResolvedAccount::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionName").getter(getter(EnvironmentResolvedAccount::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountPoolId").getter(getter(EnvironmentResolvedAccount::sourceAccountPoolId))
            .setter(setter(Builder::sourceAccountPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountPoolId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            REGION_NAME_FIELD, SOURCE_ACCOUNT_POOL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String regionName;

    private final String sourceAccountPoolId;

    private EnvironmentResolvedAccount(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.regionName = builder.regionName;
        this.sourceAccountPoolId = builder.sourceAccountPoolId;
    }

    /**
     * <p>
     * The ID of the resolved account.
     * </p>
     * 
     * @return The ID of the resolved account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of the resolved Region.
     * </p>
     * 
     * @return The name of the resolved Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The ID of the account pool.
     * </p>
     * 
     * @return The ID of the account pool.
     */
    public final String sourceAccountPoolId() {
        return sourceAccountPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountPoolId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResolvedAccount)) {
            return false;
        }
        EnvironmentResolvedAccount other = (EnvironmentResolvedAccount) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(sourceAccountPoolId(), other.sourceAccountPoolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentResolvedAccount").add("AwsAccountId", awsAccountId()).add("RegionName", regionName())
                .add("SourceAccountPoolId", sourceAccountPoolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "regionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "sourceAccountPoolId":
            return Optional.ofNullable(clazz.cast(sourceAccountPoolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("sourceAccountPoolId", SOURCE_ACCOUNT_POOL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentResolvedAccount, T> g) {
        return obj -> g.apply((EnvironmentResolvedAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentResolvedAccount> {
        /**
         * <p>
         * The ID of the resolved account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the resolved account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of the resolved Region.
         * </p>
         * 
         * @param regionName
         *        The name of the resolved Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The ID of the account pool.
         * </p>
         * 
         * @param sourceAccountPoolId
         *        The ID of the account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountPoolId(String sourceAccountPoolId);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String regionName;

        private String sourceAccountPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResolvedAccount model) {
            awsAccountId(model.awsAccountId);
            regionName(model.regionName);
            sourceAccountPoolId(model.sourceAccountPoolId);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getSourceAccountPoolId() {
            return sourceAccountPoolId;
        }

        public final void setSourceAccountPoolId(String sourceAccountPoolId) {
            this.sourceAccountPoolId = sourceAccountPoolId;
        }

        @Override
        public final Builder sourceAccountPoolId(String sourceAccountPoolId) {
            this.sourceAccountPoolId = sourceAccountPoolId;
            return this;
        }

        @Override
        public EnvironmentResolvedAccount build() {
            return new EnvironmentResolvedAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
