/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentConfiguration.Builder, EnvironmentConfiguration> {
    private static final SdkField<List<String>> ACCOUNT_POOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountPools")
            .getter(getter(EnvironmentConfiguration::accountPools))
            .setter(setter(Builder::accountPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsAccount> AWS_ACCOUNT_FIELD = SdkField.<AwsAccount> builder(MarshallingType.SDK_POJO)
            .memberName("awsAccount").getter(getter(EnvironmentConfiguration::awsAccount)).setter(setter(Builder::awsAccount))
            .constructor(AwsAccount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()).build();

    private static final SdkField<Region> AWS_REGION_FIELD = SdkField.<Region> builder(MarshallingType.SDK_POJO)
            .memberName("awsRegion").getter(getter(EnvironmentConfiguration::awsRegion)).setter(setter(Builder::awsRegion))
            .constructor(Region::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<EnvironmentConfigurationParametersDetails> CONFIGURATION_PARAMETERS_FIELD = SdkField
            .<EnvironmentConfigurationParametersDetails> builder(MarshallingType.SDK_POJO).memberName("configurationParameters")
            .getter(getter(EnvironmentConfiguration::configurationParameters)).setter(setter(Builder::configurationParameters))
            .constructor(EnvironmentConfigurationParametersDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationParameters").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentMode").getter(getter(EnvironmentConfiguration::deploymentModeAsString))
            .setter(setter(Builder::deploymentMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("deploymentOrder").getter(getter(EnvironmentConfiguration::deploymentOrder))
            .setter(setter(Builder::deploymentOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOrder").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintId").getter(getter(EnvironmentConfiguration::environmentBlueprintId))
            .setter(setter(Builder::environmentBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentConfiguration::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_POOLS_FIELD,
            AWS_ACCOUNT_FIELD, AWS_REGION_FIELD, CONFIGURATION_PARAMETERS_FIELD, DEPLOYMENT_MODE_FIELD, DEPLOYMENT_ORDER_FIELD,
            DESCRIPTION_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accountPools;

    private final AwsAccount awsAccount;

    private final Region awsRegion;

    private final EnvironmentConfigurationParametersDetails configurationParameters;

    private final String deploymentMode;

    private final Integer deploymentOrder;

    private final String description;

    private final String environmentBlueprintId;

    private final String id;

    private final String name;

    private EnvironmentConfiguration(BuilderImpl builder) {
        this.accountPools = builder.accountPools;
        this.awsAccount = builder.awsAccount;
        this.awsRegion = builder.awsRegion;
        this.configurationParameters = builder.configurationParameters;
        this.deploymentMode = builder.deploymentMode;
        this.deploymentOrder = builder.deploymentOrder;
        this.description = builder.description;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.id = builder.id;
        this.name = builder.name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountPools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountPools() {
        return accountPools != null && !(accountPools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account pools used by a custom project profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountPools} method.
     * </p>
     * 
     * @return The account pools used by a custom project profile.
     */
    public final List<String> accountPools() {
        return accountPools;
    }

    /**
     * <p>
     * The Amazon Web Services account of the environment.
     * </p>
     * 
     * @return The Amazon Web Services account of the environment.
     */
    public final AwsAccount awsAccount() {
        return awsAccount;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the environment.
     * </p>
     * 
     * @return The Amazon Web Services Region of the environment.
     */
    public final Region awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The configuration parameters of the environment.
     * </p>
     * 
     * @return The configuration parameters of the environment.
     */
    public final EnvironmentConfigurationParametersDetails configurationParameters() {
        return configurationParameters;
    }

    /**
     * <p>
     * The deployment mode of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return The deployment mode of the environment.
     * @see DeploymentMode
     */
    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(deploymentMode);
    }

    /**
     * <p>
     * The deployment mode of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return The deployment mode of the environment.
     * @see DeploymentMode
     */
    public final String deploymentModeAsString() {
        return deploymentMode;
    }

    /**
     * <p>
     * The deployment order of the environment.
     * </p>
     * 
     * @return The deployment order of the environment.
     */
    public final Integer deploymentOrder() {
        return deploymentOrder;
    }

    /**
     * <p>
     * The environment description.
     * </p>
     * 
     * @return The environment description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The environment blueprint ID.
     * </p>
     * 
     * @return The environment blueprint ID.
     */
    public final String environmentBlueprintId() {
        return environmentBlueprintId;
    }

    /**
     * <p>
     * The environment ID.
     * </p>
     * 
     * @return The environment ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The environment name.
     * </p>
     * 
     * @return The environment name.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountPools() ? accountPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(configurationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOrder());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfiguration)) {
            return false;
        }
        EnvironmentConfiguration other = (EnvironmentConfiguration) obj;
        return hasAccountPools() == other.hasAccountPools() && Objects.equals(accountPools(), other.accountPools())
                && Objects.equals(awsAccount(), other.awsAccount()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(configurationParameters(), other.configurationParameters())
                && Objects.equals(deploymentModeAsString(), other.deploymentModeAsString())
                && Objects.equals(deploymentOrder(), other.deploymentOrder())
                && Objects.equals(description(), other.description())
                && Objects.equals(environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentConfiguration").add("AccountPools", hasAccountPools() ? accountPools() : null)
                .add("AwsAccount", awsAccount()).add("AwsRegion", awsRegion())
                .add("ConfigurationParameters", configurationParameters()).add("DeploymentMode", deploymentModeAsString())
                .add("DeploymentOrder", deploymentOrder())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentBlueprintId", environmentBlueprintId())
                .add("Id", id() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountPools":
            return Optional.ofNullable(clazz.cast(accountPools()));
        case "awsAccount":
            return Optional.ofNullable(clazz.cast(awsAccount()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "configurationParameters":
            return Optional.ofNullable(clazz.cast(configurationParameters()));
        case "deploymentMode":
            return Optional.ofNullable(clazz.cast(deploymentModeAsString()));
        case "deploymentOrder":
            return Optional.ofNullable(clazz.cast(deploymentOrder()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentBlueprintId":
            return Optional.ofNullable(clazz.cast(environmentBlueprintId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountPools", ACCOUNT_POOLS_FIELD);
        map.put("awsAccount", AWS_ACCOUNT_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("configurationParameters", CONFIGURATION_PARAMETERS_FIELD);
        map.put("deploymentMode", DEPLOYMENT_MODE_FIELD);
        map.put("deploymentOrder", DEPLOYMENT_ORDER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfiguration, T> g) {
        return obj -> g.apply((EnvironmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentConfiguration> {
        /**
         * <p>
         * The account pools used by a custom project profile.
         * </p>
         * 
         * @param accountPools
         *        The account pools used by a custom project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPools(Collection<String> accountPools);

        /**
         * <p>
         * The account pools used by a custom project profile.
         * </p>
         * 
         * @param accountPools
         *        The account pools used by a custom project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPools(String... accountPools);

        /**
         * <p>
         * The Amazon Web Services account of the environment.
         * </p>
         * 
         * @param awsAccount
         *        The Amazon Web Services account of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccount(AwsAccount awsAccount);

        /**
         * <p>
         * The Amazon Web Services account of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsAccount.Builder} avoiding the need to
         * create one manually via {@link AwsAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAccount.Builder#build()} is called immediately and its result
         * is passed to {@link #awsAccount(AwsAccount)}.
         * 
         * @param awsAccount
         *        a consumer that will call methods on {@link AwsAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccount(AwsAccount)
         */
        default Builder awsAccount(Consumer<AwsAccount.Builder> awsAccount) {
            return awsAccount(AwsAccount.builder().applyMutation(awsAccount).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region of the environment.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(Region awsRegion);

        /**
         * <p>
         * The Amazon Web Services Region of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Region.Builder} avoiding the need to
         * create one manually via {@link Region#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Region.Builder#build()} is called immediately and its result is
         * passed to {@link #awsRegion(Region)}.
         * 
         * @param awsRegion
         *        a consumer that will call methods on {@link Region.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRegion(Region)
         */
        default Builder awsRegion(Consumer<Region.Builder> awsRegion) {
            return awsRegion(Region.builder().applyMutation(awsRegion).build());
        }

        /**
         * <p>
         * The configuration parameters of the environment.
         * </p>
         * 
         * @param configurationParameters
         *        The configuration parameters of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationParameters(EnvironmentConfigurationParametersDetails configurationParameters);

        /**
         * <p>
         * The configuration parameters of the environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnvironmentConfigurationParametersDetails.Builder} avoiding the need to create one manually via
         * {@link EnvironmentConfigurationParametersDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentConfigurationParametersDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #configurationParameters(EnvironmentConfigurationParametersDetails)}.
         * 
         * @param configurationParameters
         *        a consumer that will call methods on {@link EnvironmentConfigurationParametersDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationParameters(EnvironmentConfigurationParametersDetails)
         */
        default Builder configurationParameters(
                Consumer<EnvironmentConfigurationParametersDetails.Builder> configurationParameters) {
            return configurationParameters(EnvironmentConfigurationParametersDetails.builder()
                    .applyMutation(configurationParameters).build());
        }

        /**
         * <p>
         * The deployment mode of the environment.
         * </p>
         * 
         * @param deploymentMode
         *        The deployment mode of the environment.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(String deploymentMode);

        /**
         * <p>
         * The deployment mode of the environment.
         * </p>
         * 
         * @param deploymentMode
         *        The deployment mode of the environment.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(DeploymentMode deploymentMode);

        /**
         * <p>
         * The deployment order of the environment.
         * </p>
         * 
         * @param deploymentOrder
         *        The deployment order of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOrder(Integer deploymentOrder);

        /**
         * <p>
         * The environment description.
         * </p>
         * 
         * @param description
         *        The environment description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The environment blueprint ID.
         * </p>
         * 
         * @param environmentBlueprintId
         *        The environment blueprint ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintId(String environmentBlueprintId);

        /**
         * <p>
         * The environment ID.
         * </p>
         * 
         * @param id
         *        The environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The environment name.
         * </p>
         * 
         * @param name
         *        The environment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountPools = DefaultSdkAutoConstructList.getInstance();

        private AwsAccount awsAccount;

        private Region awsRegion;

        private EnvironmentConfigurationParametersDetails configurationParameters;

        private String deploymentMode;

        private Integer deploymentOrder;

        private String description;

        private String environmentBlueprintId;

        private String id;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfiguration model) {
            accountPools(model.accountPools);
            awsAccount(model.awsAccount);
            awsRegion(model.awsRegion);
            configurationParameters(model.configurationParameters);
            deploymentMode(model.deploymentMode);
            deploymentOrder(model.deploymentOrder);
            description(model.description);
            environmentBlueprintId(model.environmentBlueprintId);
            id(model.id);
            name(model.name);
        }

        public final Collection<String> getAccountPools() {
            if (accountPools instanceof SdkAutoConstructList) {
                return null;
            }
            return accountPools;
        }

        public final void setAccountPools(Collection<String> accountPools) {
            this.accountPools = AccountPoolListCopier.copy(accountPools);
        }

        @Override
        public final Builder accountPools(Collection<String> accountPools) {
            this.accountPools = AccountPoolListCopier.copy(accountPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountPools(String... accountPools) {
            accountPools(Arrays.asList(accountPools));
            return this;
        }

        public final AwsAccount.Builder getAwsAccount() {
            return awsAccount != null ? awsAccount.toBuilder() : null;
        }

        public final void setAwsAccount(AwsAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        @Override
        public final Builder awsAccount(AwsAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final Region.Builder getAwsRegion() {
            return awsRegion != null ? awsRegion.toBuilder() : null;
        }

        public final void setAwsRegion(Region.BuilderImpl awsRegion) {
            this.awsRegion = awsRegion != null ? awsRegion.build() : null;
        }

        @Override
        public final Builder awsRegion(Region awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final EnvironmentConfigurationParametersDetails.Builder getConfigurationParameters() {
            return configurationParameters != null ? configurationParameters.toBuilder() : null;
        }

        public final void setConfigurationParameters(EnvironmentConfigurationParametersDetails.BuilderImpl configurationParameters) {
            this.configurationParameters = configurationParameters != null ? configurationParameters.build() : null;
        }

        @Override
        public final Builder configurationParameters(EnvironmentConfigurationParametersDetails configurationParameters) {
            this.configurationParameters = configurationParameters;
            return this;
        }

        public final String getDeploymentMode() {
            return deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final Integer getDeploymentOrder() {
            return deploymentOrder;
        }

        public final void setDeploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
        }

        @Override
        public final Builder deploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public EnvironmentConfiguration build() {
            return new EnvironmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
