/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the domain unit owner.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainUnitOwnerProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainUnitOwnerProperties.Builder, DomainUnitOwnerProperties> {
    private static final SdkField<DomainUnitGroupProperties> GROUP_FIELD = SdkField
            .<DomainUnitGroupProperties> builder(MarshallingType.SDK_POJO).memberName("group")
            .getter(getter(DomainUnitOwnerProperties::group)).setter(setter(Builder::group))
            .constructor(DomainUnitGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<DomainUnitUserProperties> USER_FIELD = SdkField
            .<DomainUnitUserProperties> builder(MarshallingType.SDK_POJO).memberName("user")
            .getter(getter(DomainUnitOwnerProperties::user)).setter(setter(Builder::user))
            .constructor(DomainUnitUserProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainUnitGroupProperties group;

    private final DomainUnitUserProperties user;

    private final Type type;

    private DomainUnitOwnerProperties(BuilderImpl builder) {
        this.group = builder.group;
        this.user = builder.user;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates that the domain unit owner is a group.
     * </p>
     * 
     * @return Indicates that the domain unit owner is a group.
     */
    public final DomainUnitGroupProperties group() {
        return group;
    }

    /**
     * <p>
     * Indicates that the domain unit owner is a user.
     * </p>
     * 
     * @return Indicates that the domain unit owner is a user.
     */
    public final DomainUnitUserProperties user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitOwnerProperties)) {
            return false;
        }
        DomainUnitOwnerProperties other = (DomainUnitOwnerProperties) obj;
        return Objects.equals(group(), other.group()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainUnitOwnerProperties").add("Group", group()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * Indicates that the domain unit owner is a group.
     * </p>
     * 
     * @param group
     *        Indicates that the domain unit owner is a group.
     */
    public static DomainUnitOwnerProperties fromGroup(DomainUnitGroupProperties group) {
        return builder().group(group).build();
    }

    /**
     * Create an instance of this class with {@link #group()} initialized to the given value.
     *
     * <p>
     * Indicates that the domain unit owner is a group.
     * </p>
     * 
     * @param group
     *        Indicates that the domain unit owner is a group.
     */
    public static DomainUnitOwnerProperties fromGroup(Consumer<DomainUnitGroupProperties.Builder> group) {
        DomainUnitGroupProperties.Builder builder = DomainUnitGroupProperties.builder();
        group.accept(builder);
        return fromGroup(builder.build());
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * Indicates that the domain unit owner is a user.
     * </p>
     * 
     * @param user
     *        Indicates that the domain unit owner is a user.
     */
    public static DomainUnitOwnerProperties fromUser(DomainUnitUserProperties user) {
        return builder().user(user).build();
    }

    /**
     * Create an instance of this class with {@link #user()} initialized to the given value.
     *
     * <p>
     * Indicates that the domain unit owner is a user.
     * </p>
     * 
     * @param user
     *        Indicates that the domain unit owner is a user.
     */
    public static DomainUnitOwnerProperties fromUser(Consumer<DomainUnitUserProperties.Builder> user) {
        DomainUnitUserProperties.Builder builder = DomainUnitUserProperties.builder();
        user.accept(builder);
        return fromUser(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("group", GROUP_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitOwnerProperties, T> g) {
        return obj -> g.apply((DomainUnitOwnerProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainUnitOwnerProperties> {
        /**
         * <p>
         * Indicates that the domain unit owner is a group.
         * </p>
         * 
         * @param group
         *        Indicates that the domain unit owner is a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(DomainUnitGroupProperties group);

        /**
         * <p>
         * Indicates that the domain unit owner is a group.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitGroupProperties.Builder}
         * avoiding the need to create one manually via {@link DomainUnitGroupProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitGroupProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #group(DomainUnitGroupProperties)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link DomainUnitGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(DomainUnitGroupProperties)
         */
        default Builder group(Consumer<DomainUnitGroupProperties.Builder> group) {
            return group(DomainUnitGroupProperties.builder().applyMutation(group).build());
        }

        /**
         * <p>
         * Indicates that the domain unit owner is a user.
         * </p>
         * 
         * @param user
         *        Indicates that the domain unit owner is a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(DomainUnitUserProperties user);

        /**
         * <p>
         * Indicates that the domain unit owner is a user.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainUnitUserProperties.Builder}
         * avoiding the need to create one manually via {@link DomainUnitUserProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainUnitUserProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #user(DomainUnitUserProperties)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link DomainUnitUserProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(DomainUnitUserProperties)
         */
        default Builder user(Consumer<DomainUnitUserProperties.Builder> user) {
            return user(DomainUnitUserProperties.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainUnitGroupProperties group;

        private DomainUnitUserProperties user;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitOwnerProperties model) {
            group(model.group);
            user(model.user);
        }

        public final DomainUnitGroupProperties.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(DomainUnitGroupProperties.BuilderImpl group) {
            Object oldValue = this.group;
            this.group = group != null ? group.build() : null;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(DomainUnitGroupProperties group) {
            Object oldValue = this.group;
            this.group = group;
            handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final DomainUnitUserProperties.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(DomainUnitUserProperties.BuilderImpl user) {
            Object oldValue = this.user;
            this.user = user != null ? user.build() : null;
            handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(DomainUnitUserProperties user) {
            Object oldValue = this.user;
            this.user = user;
            handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public DomainUnitOwnerProperties build() {
            return new DomainUnitOwnerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DomainUnitOwnerProperties#type()
     */
    public enum Type {
        GROUP,

        USER,

        UNKNOWN_TO_SDK_VERSION
    }
}
