/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the last deployment of the environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(Deployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(Deployment::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(Deployment::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<EnvironmentError> FAILURE_REASON_FIELD = SdkField
            .<EnvironmentError> builder(MarshallingType.SDK_POJO).memberName("failureReason")
            .getter(getter(Deployment::failureReason)).setter(setter(Builder::failureReason))
            .constructor(EnvironmentError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Boolean> IS_DEPLOYMENT_COMPLETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDeploymentComplete").getter(getter(Deployment::isDeploymentComplete))
            .setter(setter(Builder::isDeploymentComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDeploymentComplete").build())
            .build();

    private static final SdkField<List<String>> MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(Deployment::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_TYPE_FIELD, FAILURE_REASON_FIELD, IS_DEPLOYMENT_COMPLETE_FIELD, MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String deploymentStatus;

    private final String deploymentType;

    private final EnvironmentError failureReason;

    private final Boolean isDeploymentComplete;

    private final List<String> messages;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.failureReason = builder.failureReason;
        this.isDeploymentComplete = builder.isDeploymentComplete;
        this.messages = builder.messages;
    }

    /**
     * <p>
     * The identifier of the last deployment of the environment.
     * </p>
     * 
     * @return The identifier of the last deployment of the environment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The status of the last deployment of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last deployment of the environment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of the last deployment of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last deployment of the environment.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The type of the last deployment of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the last deployment of the environment.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * The type of the last deployment of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the last deployment of the environment.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * The failure reason of the last deployment of the environment.
     * </p>
     * 
     * @return The failure reason of the last deployment of the environment.
     */
    public final EnvironmentError failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Specifies whether the last deployment of the environment is complete.
     * </p>
     * 
     * @return Specifies whether the last deployment of the environment is complete.
     */
    public final Boolean isDeploymentComplete() {
        return isDeploymentComplete;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The messages of the last deployment of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return The messages of the last deployment of the environment.
     */
    public final List<String> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(isDeploymentComplete());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(isDeploymentComplete(), other.isDeploymentComplete()) && hasMessages() == other.hasMessages()
                && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Deployment").add("DeploymentId", deploymentId())
                .add("DeploymentStatus", deploymentStatusAsString()).add("DeploymentType", deploymentTypeAsString())
                .add("FailureReason", failureReason()).add("IsDeploymentComplete", isDeploymentComplete())
                .add("Messages", hasMessages() ? messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "isDeploymentComplete":
            return Optional.ofNullable(clazz.cast(isDeploymentComplete()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("isDeploymentComplete", IS_DEPLOYMENT_COMPLETE_FIELD);
        map.put("messages", MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The identifier of the last deployment of the environment.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the last deployment of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The status of the last deployment of the environment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the last deployment of the environment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of the last deployment of the environment.
         * </p>
         * 
         * @param deploymentStatus
         *        The status of the last deployment of the environment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * The type of the last deployment of the environment.
         * </p>
         * 
         * @param deploymentType
         *        The type of the last deployment of the environment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * The type of the last deployment of the environment.
         * </p>
         * 
         * @param deploymentType
         *        The type of the last deployment of the environment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * The failure reason of the last deployment of the environment.
         * </p>
         * 
         * @param failureReason
         *        The failure reason of the last deployment of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(EnvironmentError failureReason);

        /**
         * <p>
         * The failure reason of the last deployment of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentError.Builder} avoiding the
         * need to create one manually via {@link EnvironmentError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentError.Builder#build()} is called immediately and its
         * result is passed to {@link #failureReason(EnvironmentError)}.
         * 
         * @param failureReason
         *        a consumer that will call methods on {@link EnvironmentError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureReason(EnvironmentError)
         */
        default Builder failureReason(Consumer<EnvironmentError.Builder> failureReason) {
            return failureReason(EnvironmentError.builder().applyMutation(failureReason).build());
        }

        /**
         * <p>
         * Specifies whether the last deployment of the environment is complete.
         * </p>
         * 
         * @param isDeploymentComplete
         *        Specifies whether the last deployment of the environment is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDeploymentComplete(Boolean isDeploymentComplete);

        /**
         * <p>
         * The messages of the last deployment of the environment.
         * </p>
         * 
         * @param messages
         *        The messages of the last deployment of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<String> messages);

        /**
         * <p>
         * The messages of the last deployment of the environment.
         * </p>
         * 
         * @param messages
         *        The messages of the last deployment of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(String... messages);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String deploymentStatus;

        private String deploymentType;

        private EnvironmentError failureReason;

        private Boolean isDeploymentComplete;

        private List<String> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            deploymentId(model.deploymentId);
            deploymentStatus(model.deploymentStatus);
            deploymentType(model.deploymentType);
            failureReason(model.failureReason);
            isDeploymentComplete(model.isDeploymentComplete);
            messages(model.messages);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final EnvironmentError.Builder getFailureReason() {
            return failureReason != null ? failureReason.toBuilder() : null;
        }

        public final void setFailureReason(EnvironmentError.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(EnvironmentError failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Boolean getIsDeploymentComplete() {
            return isDeploymentComplete;
        }

        public final void setIsDeploymentComplete(Boolean isDeploymentComplete) {
            this.isDeploymentComplete = isDeploymentComplete;
        }

        @Override
        public final Builder isDeploymentComplete(Boolean isDeploymentComplete) {
            this.isDeploymentComplete = isDeploymentComplete;
            return this;
        }

        public final Collection<String> getMessages() {
            if (messages instanceof SdkAutoConstructList) {
                return null;
            }
            return messages;
        }

        public final void setMessages(Collection<String> messages) {
            this.messages = DeploymentMessagesListCopier.copy(messages);
        }

        @Override
        public final Builder messages(Collection<String> messages) {
            this.messages = DeploymentMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(String... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
