/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom Amazon Web Services Lambda handler within an account pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAccountPoolHandler implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomAccountPoolHandler.Builder, CustomAccountPoolHandler> {
    private static final SdkField<String> LAMBDA_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaExecutionRoleArn").getter(getter(CustomAccountPoolHandler::lambdaExecutionRoleArn))
            .setter(setter(Builder::lambdaExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaExecutionRoleArn").build())
            .build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaFunctionArn").getter(getter(CustomAccountPoolHandler::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAMBDA_EXECUTION_ROLE_ARN_FIELD, LAMBDA_FUNCTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambdaExecutionRoleArn;

    private final String lambdaFunctionArn;

    private CustomAccountPoolHandler(BuilderImpl builder) {
        this.lambdaExecutionRoleArn = builder.lambdaExecutionRoleArn;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables Amazon SageMaker Unified Studio to invoke the Amazon Web Services Lambda
     * funtion if the account source is the custom account pool handler.
     * </p>
     * 
     * @return The ARN of the IAM role that enables Amazon SageMaker Unified Studio to invoke the Amazon Web Services
     *         Lambda funtion if the account source is the custom account pool handler.
     */
    public final String lambdaExecutionRoleArn() {
        return lambdaExecutionRoleArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services Lambda function for the custom Amazon Web Services Lambda handler.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services Lambda function for the custom Amazon Web Services Lambda handler.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAccountPoolHandler)) {
            return false;
        }
        CustomAccountPoolHandler other = (CustomAccountPoolHandler) obj;
        return Objects.equals(lambdaExecutionRoleArn(), other.lambdaExecutionRoleArn())
                && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAccountPoolHandler").add("LambdaExecutionRoleArn", lambdaExecutionRoleArn())
                .add("LambdaFunctionArn", lambdaFunctionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(lambdaExecutionRoleArn()));
        case "lambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaExecutionRoleArn", LAMBDA_EXECUTION_ROLE_ARN_FIELD);
        map.put("lambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomAccountPoolHandler, T> g) {
        return obj -> g.apply((CustomAccountPoolHandler) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAccountPoolHandler> {
        /**
         * <p>
         * The ARN of the IAM role that enables Amazon SageMaker Unified Studio to invoke the Amazon Web Services Lambda
         * funtion if the account source is the custom account pool handler.
         * </p>
         * 
         * @param lambdaExecutionRoleArn
         *        The ARN of the IAM role that enables Amazon SageMaker Unified Studio to invoke the Amazon Web Services
         *        Lambda funtion if the account source is the custom account pool handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaExecutionRoleArn(String lambdaExecutionRoleArn);

        /**
         * <p>
         * The ARN of the Amazon Web Services Lambda function for the custom Amazon Web Services Lambda handler.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        The ARN of the Amazon Web Services Lambda function for the custom Amazon Web Services Lambda handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaExecutionRoleArn;

        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAccountPoolHandler model) {
            lambdaExecutionRoleArn(model.lambdaExecutionRoleArn);
            lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final String getLambdaExecutionRoleArn() {
            return lambdaExecutionRoleArn;
        }

        public final void setLambdaExecutionRoleArn(String lambdaExecutionRoleArn) {
            this.lambdaExecutionRoleArn = lambdaExecutionRoleArn;
        }

        @Override
        public final Builder lambdaExecutionRoleArn(String lambdaExecutionRoleArn) {
            this.lambdaExecutionRoleArn = lambdaExecutionRoleArn;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        @Override
        public CustomAccountPoolHandler build() {
            return new CustomAccountPoolHandler(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
