/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlossaryTermRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateGlossaryTermRequest.Builder, CreateGlossaryTermRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateGlossaryTermRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateGlossaryTermRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> GLOSSARY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glossaryIdentifier").getter(getter(CreateGlossaryTermRequest::glossaryIdentifier))
            .setter(setter(Builder::glossaryIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryIdentifier").build())
            .build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("longDescription").getter(getter(CreateGlossaryTermRequest::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGlossaryTermRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortDescription").getter(getter(CreateGlossaryTermRequest::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGlossaryTermRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField
            .<TermRelations> builder(MarshallingType.SDK_POJO).memberName("termRelations")
            .getter(getter(CreateGlossaryTermRequest::termRelations)).setter(setter(Builder::termRelations))
            .constructor(TermRelations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, GLOSSARY_IDENTIFIER_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD,
            STATUS_FIELD, TERM_RELATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String domainIdentifier;

    private final String glossaryIdentifier;

    private final String longDescription;

    private final String name;

    private final String shortDescription;

    private final String status;

    private final TermRelations termRelations;

    private CreateGlossaryTermRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.glossaryIdentifier = builder.glossaryIdentifier;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this business glossary term is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this business glossary term is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the business glossary in which this term is created.
     * </p>
     * 
     * @return The ID of the business glossary in which this term is created.
     */
    public final String glossaryIdentifier() {
        return glossaryIdentifier;
    }

    /**
     * <p>
     * The long description of this business glossary term.
     * </p>
     * 
     * @return The long description of this business glossary term.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The name of this business glossary term.
     * </p>
     * 
     * @return The name of this business glossary term.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The short description of this business glossary term.
     * </p>
     * 
     * @return The short description of this business glossary term.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * The status of this business glossary term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary term.
     * @see GlossaryTermStatus
     */
    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this business glossary term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary term.
     * @see GlossaryTermStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The term relations of this business glossary term.
     * </p>
     * 
     * @return The term relations of this business glossary term.
     */
    public final TermRelations termRelations() {
        return termRelations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(glossaryIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termRelations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryTermRequest)) {
            return false;
        }
        CreateGlossaryTermRequest other = (CreateGlossaryTermRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(glossaryIdentifier(), other.glossaryIdentifier())
                && Objects.equals(longDescription(), other.longDescription()) && Objects.equals(name(), other.name())
                && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(termRelations(), other.termRelations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlossaryTermRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("GlossaryIdentifier", glossaryIdentifier())
                .add("LongDescription", longDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShortDescription", shortDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("TermRelations", termRelations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "glossaryIdentifier":
            return Optional.ofNullable(clazz.cast(glossaryIdentifier()));
        case "longDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "shortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "termRelations":
            return Optional.ofNullable(clazz.cast(termRelations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("glossaryIdentifier", GLOSSARY_IDENTIFIER_FIELD);
        map.put("longDescription", LONG_DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("shortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("termRelations", TERM_RELATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryTermRequest, T> g) {
        return obj -> g.apply((CreateGlossaryTermRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlossaryTermRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this business glossary term is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which this business glossary term is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the business glossary in which this term is created.
         * </p>
         * 
         * @param glossaryIdentifier
         *        The ID of the business glossary in which this term is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryIdentifier(String glossaryIdentifier);

        /**
         * <p>
         * The long description of this business glossary term.
         * </p>
         * 
         * @param longDescription
         *        The long description of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The name of this business glossary term.
         * </p>
         * 
         * @param name
         *        The name of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The short description of this business glossary term.
         * </p>
         * 
         * @param shortDescription
         *        The short description of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * The status of this business glossary term.
         * </p>
         * 
         * @param status
         *        The status of this business glossary term.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this business glossary term.
         * </p>
         * 
         * @param status
         *        The status of this business glossary term.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(GlossaryTermStatus status);

        /**
         * <p>
         * The term relations of this business glossary term.
         * </p>
         * 
         * @param termRelations
         *        The term relations of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termRelations(TermRelations termRelations);

        /**
         * <p>
         * The term relations of this business glossary term.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermRelations.Builder} avoiding the need
         * to create one manually via {@link TermRelations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermRelations.Builder#build()} is called immediately and its
         * result is passed to {@link #termRelations(TermRelations)}.
         * 
         * @param termRelations
         *        a consumer that will call methods on {@link TermRelations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termRelations(TermRelations)
         */
        default Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return termRelations(TermRelations.builder().applyMutation(termRelations).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String glossaryIdentifier;

        private String longDescription;

        private String name;

        private String shortDescription;

        private String status;

        private TermRelations termRelations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryTermRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            glossaryIdentifier(model.glossaryIdentifier);
            longDescription(model.longDescription);
            name(model.name);
            shortDescription(model.shortDescription);
            status(model.status);
            termRelations(model.termRelations);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getGlossaryIdentifier() {
            return glossaryIdentifier;
        }

        public final void setGlossaryIdentifier(String glossaryIdentifier) {
            this.glossaryIdentifier = glossaryIdentifier;
        }

        @Override
        public final Builder glossaryIdentifier(String glossaryIdentifier) {
            this.glossaryIdentifier = glossaryIdentifier;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return termRelations != null ? termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlossaryTermRequest build() {
            return new CreateGlossaryTermRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
