/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The account ID of a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAccount implements SdkPojo, Serializable, ToCopyableBuilder<AwsAccount.Builder, AwsAccount> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(AwsAccount::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountIdPath").getter(getter(AwsAccount::awsAccountIdPath))
            .setter(setter(Builder::awsAccountIdPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIdPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_ID_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsAccountIdPath;

    private final Type type;

    private AwsAccount(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountIdPath = builder.awsAccountIdPath;
        this.type = builder.type;
    }

    /**
     * <p>
     * The account ID of a project.
     * </p>
     * 
     * @return The account ID of a project.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The account ID path of a project.
     * </p>
     * 
     * @return The account ID path of a project.
     */
    public final String awsAccountIdPath() {
        return awsAccountIdPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountIdPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAccount)) {
            return false;
        }
        AwsAccount other = (AwsAccount) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountIdPath(), other.awsAccountIdPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAccount").add("AwsAccountId", awsAccountId()).add("AwsAccountIdPath", awsAccountIdPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountIdPath":
            return Optional.ofNullable(clazz.cast(awsAccountIdPath()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsAccountId()} initialized to the given value.
     *
     * <p>
     * The account ID of a project.
     * </p>
     * 
     * @param awsAccountId
     *        The account ID of a project.
     */
    public static AwsAccount fromAwsAccountId(String awsAccountId) {
        return builder().awsAccountId(awsAccountId).build();
    }

    /**
     * Create an instance of this class with {@link #awsAccountIdPath()} initialized to the given value.
     *
     * <p>
     * The account ID path of a project.
     * </p>
     * 
     * @param awsAccountIdPath
     *        The account ID path of a project.
     */
    public static AwsAccount fromAwsAccountIdPath(String awsAccountIdPath) {
        return builder().awsAccountIdPath(awsAccountIdPath).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountIdPath", AWS_ACCOUNT_ID_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAccount, T> g) {
        return obj -> g.apply((AwsAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAccount> {
        /**
         * <p>
         * The account ID of a project.
         * </p>
         * 
         * @param awsAccountId
         *        The account ID of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The account ID path of a project.
         * </p>
         * 
         * @param awsAccountIdPath
         *        The account ID path of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIdPath(String awsAccountIdPath);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountIdPath;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAccount model) {
            awsAccountId(model.awsAccountId);
            awsAccountIdPath(model.awsAccountIdPath);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            Object oldValue = this.awsAccountId;
            this.awsAccountId = awsAccountId;
            handleUnionValueChange(Type.AWS_ACCOUNT_ID, oldValue, this.awsAccountId);
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            Object oldValue = this.awsAccountId;
            this.awsAccountId = awsAccountId;
            handleUnionValueChange(Type.AWS_ACCOUNT_ID, oldValue, this.awsAccountId);
            return this;
        }

        public final String getAwsAccountIdPath() {
            return awsAccountIdPath;
        }

        public final void setAwsAccountIdPath(String awsAccountIdPath) {
            Object oldValue = this.awsAccountIdPath;
            this.awsAccountIdPath = awsAccountIdPath;
            handleUnionValueChange(Type.AWS_ACCOUNT_ID_PATH, oldValue, this.awsAccountIdPath);
        }

        @Override
        public final Builder awsAccountIdPath(String awsAccountIdPath) {
            Object oldValue = this.awsAccountIdPath;
            this.awsAccountIdPath = awsAccountIdPath;
            handleUnionValueChange(Type.AWS_ACCOUNT_ID_PATH, oldValue, this.awsAccountIdPath);
            return this;
        }

        @Override
        public AwsAccount build() {
            return new AwsAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AwsAccount#type()
     */
    public enum Type {
        AWS_ACCOUNT_ID,

        AWS_ACCOUNT_ID_PATH,

        UNKNOWN_TO_SDK_VERSION
    }
}
