/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attribute input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeInput implements SdkPojo, Serializable, ToCopyableBuilder<AttributeInput.Builder, AttributeInput> {
    private static final SdkField<String> ATTRIBUTE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeIdentifier").getter(getter(AttributeInput::attributeIdentifier))
            .setter(setter(Builder::attributeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeIdentifier").build())
            .build();

    private static final SdkField<List<FormInput>> FORMS_FIELD = SdkField
            .<List<FormInput>> builder(MarshallingType.LIST)
            .memberName("forms")
            .getter(getter(AttributeInput::forms))
            .setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_IDENTIFIER_FIELD,
            FORMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeIdentifier;

    private final List<FormInput> forms;

    private AttributeInput(BuilderImpl builder) {
        this.attributeIdentifier = builder.attributeIdentifier;
        this.forms = builder.forms;
    }

    /**
     * <p>
     * The ID of the attribute.
     * </p>
     * 
     * @return The ID of the attribute.
     */
    public final String attributeIdentifier() {
        return attributeIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Forms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasForms() {
        return forms != null && !(forms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata forms as part of the attribute input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForms} method.
     * </p>
     * 
     * @return The metadata forms as part of the attribute input.
     */
    public final List<FormInput> forms() {
        return forms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasForms() ? forms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeInput)) {
            return false;
        }
        AttributeInput other = (AttributeInput) obj;
        return Objects.equals(attributeIdentifier(), other.attributeIdentifier()) && hasForms() == other.hasForms()
                && Objects.equals(forms(), other.forms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeInput").add("AttributeIdentifier", attributeIdentifier())
                .add("Forms", forms() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeIdentifier":
            return Optional.ofNullable(clazz.cast(attributeIdentifier()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributeIdentifier", ATTRIBUTE_IDENTIFIER_FIELD);
        map.put("forms", FORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeInput, T> g) {
        return obj -> g.apply((AttributeInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeInput> {
        /**
         * <p>
         * The ID of the attribute.
         * </p>
         * 
         * @param attributeIdentifier
         *        The ID of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeIdentifier(String attributeIdentifier);

        /**
         * <p>
         * The metadata forms as part of the attribute input.
         * </p>
         * 
         * @param forms
         *        The metadata forms as part of the attribute input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(Collection<FormInput> forms);

        /**
         * <p>
         * The metadata forms as part of the attribute input.
         * </p>
         * 
         * @param forms
         *        The metadata forms as part of the attribute input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(FormInput... forms);

        /**
         * <p>
         * The metadata forms as part of the attribute input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder#build()} is called immediately and
         * its result is passed to {@link #forms(List<FormInput>)}.
         * 
         * @param forms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forms(java.util.Collection<FormInput>)
         */
        Builder forms(Consumer<FormInput.Builder>... forms);
    }

    static final class BuilderImpl implements Builder {
        private String attributeIdentifier;

        private List<FormInput> forms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeInput model) {
            attributeIdentifier(model.attributeIdentifier);
            forms(model.forms);
        }

        public final String getAttributeIdentifier() {
            return attributeIdentifier;
        }

        public final void setAttributeIdentifier(String attributeIdentifier) {
            this.attributeIdentifier = attributeIdentifier;
        }

        @Override
        public final Builder attributeIdentifier(String attributeIdentifier) {
            this.attributeIdentifier = attributeIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getForms() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.forms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForms(Collection<FormInput.BuilderImpl> forms) {
            this.forms = FormInputListCopier.copyFromBuilder(forms);
        }

        @Override
        public final Builder forms(Collection<FormInput> forms) {
            this.forms = FormInputListCopier.copy(forms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(FormInput... forms) {
            forms(Arrays.asList(forms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(Consumer<FormInput.Builder>... forms) {
            forms(Stream.of(forms).map(c -> FormInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttributeInput build() {
            return new AttributeInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
