/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPermission implements SdkPojo, Serializable, ToCopyableBuilder<AssetPermission.Builder, AssetPermission> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(AssetPermission::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<Permissions> PERMISSIONS_FIELD = SdkField.<Permissions> builder(MarshallingType.SDK_POJO)
            .memberName("permissions").getter(getter(AssetPermission::permissions)).setter(setter(Builder::permissions))
            .constructor(Permissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final Permissions permissions;

    private AssetPermission(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The asset ID as part of the asset permissions.
     * </p>
     * 
     * @return The asset ID as part of the asset permissions.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The details as part of the asset permissions.
     * </p>
     * 
     * @return The details as part of the asset permissions.
     */
    public final Permissions permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPermission)) {
            return false;
        }
        AssetPermission other = (AssetPermission) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPermission").add("AssetId", assetId()).add("Permissions", permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetPermission, T> g) {
        return obj -> g.apply((AssetPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPermission> {
        /**
         * <p>
         * The asset ID as part of the asset permissions.
         * </p>
         * 
         * @param assetId
         *        The asset ID as part of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The details as part of the asset permissions.
         * </p>
         * 
         * @param permissions
         *        The details as part of the asset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permissions permissions);

        /**
         * <p>
         * The details as part of the asset permissions.
         * </p>
         * This is a convenience method that creates an instance of the {@link Permissions.Builder} avoiding the need to
         * create one manually via {@link Permissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Permissions.Builder#build()} is called immediately and its result
         * is passed to {@link #permissions(Permissions)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link Permissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(Permissions)
         */
        default Builder permissions(Consumer<Permissions.Builder> permissions) {
            return permissions(Permissions.builder().applyMutation(permissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private Permissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPermission model) {
            assetId(model.assetId);
            permissions(model.permissions);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Permissions.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(Permissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public AssetPermission build() {
            return new AssetPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
