/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation output item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationOutputItem.Builder, AggregationOutputItem> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(AggregationOutputItem::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> DISPLAY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayValue").getter(getter(AggregationOutputItem::displayValue)).setter(setter(Builder::displayValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayValue").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(AggregationOutputItem::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            DISPLAY_VALUE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String displayValue;

    private final String value;

    private AggregationOutputItem(BuilderImpl builder) {
        this.count = builder.count;
        this.displayValue = builder.displayValue;
        this.value = builder.value;
    }

    /**
     * <p>
     * The count of the aggregation output item.
     * </p>
     * 
     * @return The count of the aggregation output item.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The display value of the aggregation. If the attribute being aggregated corresponds to the id of a public
     * resource, the service automatically resolves the id to the provided display value.
     * </p>
     * 
     * @return The display value of the aggregation. If the attribute being aggregated corresponds to the id of a public
     *         resource, the service automatically resolves the id to the provided display value.
     */
    public final String displayValue() {
        return displayValue;
    }

    /**
     * <p>
     * The attribute value of the aggregation output item.
     * </p>
     * 
     * @return The attribute value of the aggregation output item.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(displayValue());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationOutputItem)) {
            return false;
        }
        AggregationOutputItem other = (AggregationOutputItem) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(displayValue(), other.displayValue())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationOutputItem").add("Count", count()).add("DisplayValue", displayValue())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "displayValue":
            return Optional.ofNullable(clazz.cast(displayValue()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("displayValue", DISPLAY_VALUE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationOutputItem, T> g) {
        return obj -> g.apply((AggregationOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationOutputItem> {
        /**
         * <p>
         * The count of the aggregation output item.
         * </p>
         * 
         * @param count
         *        The count of the aggregation output item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The display value of the aggregation. If the attribute being aggregated corresponds to the id of a public
         * resource, the service automatically resolves the id to the provided display value.
         * </p>
         * 
         * @param displayValue
         *        The display value of the aggregation. If the attribute being aggregated corresponds to the id of a
         *        public resource, the service automatically resolves the id to the provided display value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayValue(String displayValue);

        /**
         * <p>
         * The attribute value of the aggregation output item.
         * </p>
         * 
         * @param value
         *        The attribute value of the aggregation output item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String displayValue;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationOutputItem model) {
            count(model.count);
            displayValue(model.displayValue);
            value(model.value);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getDisplayValue() {
            return displayValue;
        }

        public final void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        @Override
        public final Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AggregationOutputItem build() {
            return new AggregationOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
