/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ApplicableAssetTypesCopier;
import software.amazon.awssdk.services.datazone.model.AuthorizedPrincipalIdentifiersCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetFormsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSubscriptionTargetResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetSubscriptionTargetResponse> {
    private static final SdkField<List<String>> APPLICABLE_ASSET_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicableAssetTypes").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::applicableAssetTypes)).setter(GetSubscriptionTargetResponse.setter(Builder::applicableAssetTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableAssetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authorizedPrincipals").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::authorizedPrincipals)).setter(GetSubscriptionTargetResponse.setter(Builder::authorizedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::createdAt)).setter(GetSubscriptionTargetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::createdBy)).setter(GetSubscriptionTargetResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::domainId)).setter(GetSubscriptionTargetResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::environmentId)).setter(GetSubscriptionTargetResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::id)).setter(GetSubscriptionTargetResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MANAGE_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("manageAccessRole").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::manageAccessRole)).setter(GetSubscriptionTargetResponse.setter(Builder::manageAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRole").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::name)).setter(GetSubscriptionTargetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::projectId)).setter(GetSubscriptionTargetResponse.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::provider)).setter(GetSubscriptionTargetResponse.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<List<SubscriptionTargetForm>> SUBSCRIPTION_TARGET_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscriptionTargetConfig").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::subscriptionTargetConfig)).setter(GetSubscriptionTargetResponse.setter(Builder::subscriptionTargetConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscriptionTargetForm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::type)).setter(GetSubscriptionTargetResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::updatedAt)).setter(GetSubscriptionTargetResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetSubscriptionTargetResponse.getter(GetSubscriptionTargetResponse::updatedBy)).setter(GetSubscriptionTargetResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_ASSET_TYPES_FIELD, AUTHORIZED_PRINCIPALS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_ID_FIELD, ID_FIELD, MANAGE_ACCESS_ROLE_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PROVIDER_FIELD, SUBSCRIPTION_TARGET_CONFIG_FIELD, TYPE_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSubscriptionTargetResponse.memberNameToFieldInitializer();
    private final List<String> applicableAssetTypes;
    private final List<String> authorizedPrincipals;
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final String environmentId;
    private final String id;
    private final String manageAccessRole;
    private final String name;
    private final String projectId;
    private final String provider;
    private final List<SubscriptionTargetForm> subscriptionTargetConfig;
    private final String type;
    private final Instant updatedAt;
    private final String updatedBy;

    private GetSubscriptionTargetResponse(BuilderImpl builder) {
        super(builder);
        this.applicableAssetTypes = builder.applicableAssetTypes;
        this.authorizedPrincipals = builder.authorizedPrincipals;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.environmentId = builder.environmentId;
        this.id = builder.id;
        this.manageAccessRole = builder.manageAccessRole;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.provider = builder.provider;
        this.subscriptionTargetConfig = builder.subscriptionTargetConfig;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final boolean hasApplicableAssetTypes() {
        return this.applicableAssetTypes != null && !(this.applicableAssetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> applicableAssetTypes() {
        return this.applicableAssetTypes;
    }

    public final boolean hasAuthorizedPrincipals() {
        return this.authorizedPrincipals != null && !(this.authorizedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedPrincipals() {
        return this.authorizedPrincipals;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String id() {
        return this.id;
    }

    public final String manageAccessRole() {
        return this.manageAccessRole;
    }

    public final String name() {
        return this.name;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String provider() {
        return this.provider;
    }

    public final boolean hasSubscriptionTargetConfig() {
        return this.subscriptionTargetConfig != null && !(this.subscriptionTargetConfig instanceof SdkAutoConstructList);
    }

    public final List<SubscriptionTargetForm> subscriptionTargetConfig() {
        return this.subscriptionTargetConfig;
    }

    public final String type() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableAssetTypes() ? this.applicableAssetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedPrincipals() ? this.authorizedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionTargetConfig() ? this.subscriptionTargetConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionTargetResponse)) {
            return false;
        }
        GetSubscriptionTargetResponse other = (GetSubscriptionTargetResponse)((Object)obj);
        return this.hasApplicableAssetTypes() == other.hasApplicableAssetTypes() && Objects.equals(this.applicableAssetTypes(), other.applicableAssetTypes()) && this.hasAuthorizedPrincipals() == other.hasAuthorizedPrincipals() && Objects.equals(this.authorizedPrincipals(), other.authorizedPrincipals()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.manageAccessRole(), other.manageAccessRole()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.provider(), other.provider()) && this.hasSubscriptionTargetConfig() == other.hasSubscriptionTargetConfig() && Objects.equals(this.subscriptionTargetConfig(), other.subscriptionTargetConfig()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetSubscriptionTargetResponse").add("ApplicableAssetTypes", this.hasApplicableAssetTypes() ? this.applicableAssetTypes() : null).add("AuthorizedPrincipals", this.hasAuthorizedPrincipals() ? this.authorizedPrincipals() : null).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("EnvironmentId", (Object)this.environmentId()).add("Id", (Object)this.id()).add("ManageAccessRole", (Object)this.manageAccessRole()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectId", (Object)this.projectId()).add("Provider", (Object)this.provider()).add("SubscriptionTargetConfig", this.hasSubscriptionTargetConfig() ? this.subscriptionTargetConfig() : null).add("Type", (Object)this.type()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicableAssetTypes": {
                return Optional.ofNullable(clazz.cast(this.applicableAssetTypes()));
            }
            case "authorizedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.authorizedPrincipals()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "manageAccessRole": {
                return Optional.ofNullable(clazz.cast(this.manageAccessRole()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "subscriptionTargetConfig": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTargetConfig()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicableAssetTypes", APPLICABLE_ASSET_TYPES_FIELD);
        map.put("authorizedPrincipals", AUTHORIZED_PRINCIPALS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("manageAccessRole", MANAGE_ACCESS_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("subscriptionTargetConfig", SUBSCRIPTION_TARGET_CONFIG_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSubscriptionTargetResponse, T> g) {
        return obj -> g.apply((GetSubscriptionTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<String> applicableAssetTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> authorizedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private String environmentId;
        private String id;
        private String manageAccessRole;
        private String name;
        private String projectId;
        private String provider;
        private List<SubscriptionTargetForm> subscriptionTargetConfig = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionTargetResponse model) {
            super(model);
            this.applicableAssetTypes(model.applicableAssetTypes);
            this.authorizedPrincipals(model.authorizedPrincipals);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.environmentId(model.environmentId);
            this.id(model.id);
            this.manageAccessRole(model.manageAccessRole);
            this.name(model.name);
            this.projectId(model.projectId);
            this.provider(model.provider);
            this.subscriptionTargetConfig(model.subscriptionTargetConfig);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Collection<String> getApplicableAssetTypes() {
            if (this.applicableAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicableAssetTypes;
        }

        public final void setApplicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
        }

        @Override
        public final Builder applicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableAssetTypes(String ... applicableAssetTypes) {
            this.applicableAssetTypes(Arrays.asList(applicableAssetTypes));
            return this;
        }

        public final Collection<String> getAuthorizedPrincipals() {
            if (this.authorizedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedPrincipals;
        }

        public final void setAuthorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
        }

        @Override
        public final Builder authorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipals(String ... authorizedPrincipals) {
            this.authorizedPrincipals(Arrays.asList(authorizedPrincipals));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getManageAccessRole() {
            return this.manageAccessRole;
        }

        public final void setManageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
        }

        @Override
        public final Builder manageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<SubscriptionTargetForm.Builder> getSubscriptionTargetConfig() {
            List<SubscriptionTargetForm.Builder> result = SubscriptionTargetFormsCopier.copyToBuilder(this.subscriptionTargetConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionTargetConfig(Collection<SubscriptionTargetForm.BuilderImpl> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copyFromBuilder(subscriptionTargetConfig);
        }

        @Override
        public final Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copy(subscriptionTargetConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(SubscriptionTargetForm ... subscriptionTargetConfig) {
            this.subscriptionTargetConfig(Arrays.asList(subscriptionTargetConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder> ... subscriptionTargetConfig) {
            this.subscriptionTargetConfig(Stream.of(subscriptionTargetConfig).map(c -> (SubscriptionTargetForm)((SubscriptionTargetForm.Builder)SubscriptionTargetForm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetSubscriptionTargetResponse build() {
            return new GetSubscriptionTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSubscriptionTargetResponse> {
        public Builder applicableAssetTypes(Collection<String> var1);

        public Builder applicableAssetTypes(String ... var1);

        public Builder authorizedPrincipals(Collection<String> var1);

        public Builder authorizedPrincipals(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder environmentId(String var1);

        public Builder id(String var1);

        public Builder manageAccessRole(String var1);

        public Builder name(String var1);

        public Builder projectId(String var1);

        public Builder provider(String var1);

        public Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> var1);

        public Builder subscriptionTargetConfig(SubscriptionTargetForm ... var1);

        public Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder> ... var1);

        public Builder type(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

