/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.LineageEventProcessingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLineageEventResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetLineageEventResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetLineageEventResponse.getter(GetLineageEventResponse::createdAt)).setter(GetLineageEventResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Created-At").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetLineageEventResponse.getter(GetLineageEventResponse::createdBy)).setter(GetLineageEventResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Created-By").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetLineageEventResponse.getter(GetLineageEventResponse::domainId)).setter(GetLineageEventResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Domain-Id").build()}).build();
    private static final SdkField<SdkBytes> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("event").getter(GetLineageEventResponse.getter(GetLineageEventResponse::event)).setter(GetLineageEventResponse.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build(), PayloadTrait.create()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(GetLineageEventResponse.getter(GetLineageEventResponse::eventTime)).setter(GetLineageEventResponse.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Event-Time").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetLineageEventResponse.getter(GetLineageEventResponse::id)).setter(GetLineageEventResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Id").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processingStatus").getter(GetLineageEventResponse.getter(GetLineageEventResponse::processingStatusAsString)).setter(GetLineageEventResponse.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Processing-Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, EVENT_FIELD, EVENT_TIME_FIELD, ID_FIELD, PROCESSING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLineageEventResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final SdkBytes event;
    private final Instant eventTime;
    private final String id;
    private final String processingStatus;

    private GetLineageEventResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.event = builder.event;
        this.eventTime = builder.eventTime;
        this.id = builder.id;
        this.processingStatus = builder.processingStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final SdkBytes event() {
        return this.event;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String id() {
        return this.id;
    }

    public final LineageEventProcessingStatus processingStatus() {
        return LineageEventProcessingStatus.fromValue(this.processingStatus);
    }

    public final String processingStatusAsString() {
        return this.processingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageEventResponse)) {
            return false;
        }
        GetLineageEventResponse other = (GetLineageEventResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.event(), other.event()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.processingStatusAsString(), other.processingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetLineageEventResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("Event", (Object)(this.event() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTime", (Object)this.eventTime()).add("Id", (Object)this.id()).add("ProcessingStatus", (Object)this.processingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "processingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Created-At", CREATED_AT_FIELD);
        map.put("Created-By", CREATED_BY_FIELD);
        map.put("Domain-Id", DOMAIN_ID_FIELD);
        map.put("event", EVENT_FIELD);
        map.put("Event-Time", EVENT_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Processing-Status", PROCESSING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLineageEventResponse, T> g) {
        return obj -> g.apply((GetLineageEventResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private SdkBytes event;
        private Instant eventTime;
        private String id;
        private String processingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageEventResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.event(model.event);
            this.eventTime(model.eventTime);
            this.id(model.id);
            this.processingStatus(model.processingStatus);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final ByteBuffer getEvent() {
            return this.event == null ? null : this.event.asByteBuffer();
        }

        public final void setEvent(ByteBuffer event) {
            this.event(event == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)event));
        }

        @Override
        public final Builder event(SdkBytes event) {
            this.event = event;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(LineageEventProcessingStatus processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        @Override
        public GetLineageEventResponse build() {
            return new GetLineageEventResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLineageEventResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder event(SdkBytes var1);

        public Builder eventTime(Instant var1);

        public Builder id(String var1);

        public Builder processingStatus(String var1);

        public Builder processingStatus(LineageEventProcessingStatus var1);
    }
}

