/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AwsLocation;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesInput;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateConnectionRequest> {
    private static final SdkField<AwsLocation> AWS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsLocation").getter(CreateConnectionRequest.getter(CreateConnectionRequest::awsLocation)).setter(CreateConnectionRequest.setter(Builder::awsLocation)).constructor(AwsLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLocation").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateConnectionRequest.getter(CreateConnectionRequest::clientToken)).setter(CreateConnectionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConnectionRequest.getter(CreateConnectionRequest::description)).setter(CreateConnectionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateConnectionRequest.getter(CreateConnectionRequest::domainIdentifier)).setter(CreateConnectionRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentIdentifier").getter(CreateConnectionRequest.getter(CreateConnectionRequest::environmentIdentifier)).setter(CreateConnectionRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConnectionRequest.getter(CreateConnectionRequest::name)).setter(CreateConnectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConnectionPropertiesInput> PROPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("props").getter(CreateConnectionRequest.getter(CreateConnectionRequest::props)).setter(CreateConnectionRequest.setter(Builder::props)).constructor(ConnectionPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOCATION_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionRequest.memberNameToFieldInitializer();
    private final AwsLocation awsLocation;
    private final String clientToken;
    private final String description;
    private final String domainIdentifier;
    private final String environmentIdentifier;
    private final String name;
    private final ConnectionPropertiesInput props;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.awsLocation = builder.awsLocation;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.props = builder.props;
    }

    public final AwsLocation awsLocation() {
        return this.awsLocation;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final ConnectionPropertiesInput props() {
        return this.props;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.props());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest)((Object)obj);
        return Objects.equals(this.awsLocation(), other.awsLocation()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.props(), other.props());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionRequest").add("AwsLocation", (Object)this.awsLocation()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("Name", (Object)this.name()).add("Props", (Object)this.props()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsLocation": {
                return Optional.ofNullable(clazz.cast(this.awsLocation()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "props": {
                return Optional.ofNullable(clazz.cast(this.props()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsLocation", AWS_LOCATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("props", PROPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private AwsLocation awsLocation;
        private String clientToken;
        private String description;
        private String domainIdentifier;
        private String environmentIdentifier;
        private String name;
        private ConnectionPropertiesInput props;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            this.awsLocation(model.awsLocation);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.name(model.name);
            this.props(model.props);
        }

        public final AwsLocation.Builder getAwsLocation() {
            return this.awsLocation != null ? this.awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AwsLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AwsLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectionPropertiesInput.Builder getProps() {
            return this.props != null ? this.props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesInput.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesInput props) {
            this.props = props;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionRequest> {
        public Builder awsLocation(AwsLocation var1);

        default public Builder awsLocation(Consumer<AwsLocation.Builder> awsLocation) {
            return this.awsLocation((AwsLocation)((AwsLocation.Builder)AwsLocation.builder().applyMutation(awsLocation)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder name(String var1);

        public Builder props(ConnectionPropertiesInput var1);

        default public Builder props(Consumer<ConnectionPropertiesInput.Builder> props) {
            return this.props((ConnectionPropertiesInput)((ConnectionPropertiesInput.Builder)ConnectionPropertiesInput.builder().applyMutation(props)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

