/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeEnvironments {
    SPARK("SPARK"),
    ATHENA("ATHENA"),
    PYTHON("PYTHON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeEnvironments> VALUE_MAP;
    private final String value;

    private ComputeEnvironments(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeEnvironments fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeEnvironments> knownValues() {
        EnumSet<ComputeEnvironments> knownValues = EnumSet.allOf(ComputeEnvironments.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeEnvironments.class, ComputeEnvironments::toString);
    }
}

