/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.PredictionChoicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectChoice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RejectChoice> {
    private static final SdkField<List<Integer>> PREDICTION_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("predictionChoices").getter(RejectChoice.getter(RejectChoice::predictionChoices)).setter(RejectChoice.setter(Builder::predictionChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREDICTION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("predictionTarget").getter(RejectChoice.getter(RejectChoice::predictionTarget)).setter(RejectChoice.setter(Builder::predictionTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTION_CHOICES_FIELD, PREDICTION_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("predictionChoices", PREDICTION_CHOICES_FIELD);
            this.put("predictionTarget", PREDICTION_TARGET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Integer> predictionChoices;
    private final String predictionTarget;

    private RejectChoice(BuilderImpl builder) {
        this.predictionChoices = builder.predictionChoices;
        this.predictionTarget = builder.predictionTarget;
    }

    public final boolean hasPredictionChoices() {
        return this.predictionChoices != null && !(this.predictionChoices instanceof SdkAutoConstructList);
    }

    public final List<Integer> predictionChoices() {
        return this.predictionChoices;
    }

    public final String predictionTarget() {
        return this.predictionTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictionChoices() ? this.predictionChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectChoice)) {
            return false;
        }
        RejectChoice other = (RejectChoice)obj;
        return this.hasPredictionChoices() == other.hasPredictionChoices() && Objects.equals(this.predictionChoices(), other.predictionChoices()) && Objects.equals(this.predictionTarget(), other.predictionTarget());
    }

    public final String toString() {
        return ToString.builder((String)"RejectChoice").add("PredictionChoices", this.hasPredictionChoices() ? this.predictionChoices() : null).add("PredictionTarget", (Object)this.predictionTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "predictionChoices": {
                return Optional.ofNullable(clazz.cast(this.predictionChoices()));
            }
            case "predictionTarget": {
                return Optional.ofNullable(clazz.cast(this.predictionTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RejectChoice, T> g) {
        return obj -> g.apply((RejectChoice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> predictionChoices = DefaultSdkAutoConstructList.getInstance();
        private String predictionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectChoice model) {
            this.predictionChoices(model.predictionChoices);
            this.predictionTarget(model.predictionTarget);
        }

        public final Collection<Integer> getPredictionChoices() {
            if (this.predictionChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.predictionChoices;
        }

        public final void setPredictionChoices(Collection<Integer> predictionChoices) {
            this.predictionChoices = PredictionChoicesCopier.copy(predictionChoices);
        }

        @Override
        public final Builder predictionChoices(Collection<Integer> predictionChoices) {
            this.predictionChoices = PredictionChoicesCopier.copy(predictionChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictionChoices(Integer ... predictionChoices) {
            this.predictionChoices(Arrays.asList(predictionChoices));
            return this;
        }

        public final String getPredictionTarget() {
            return this.predictionTarget;
        }

        public final void setPredictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
        }

        @Override
        public final Builder predictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
            return this;
        }

        public RejectChoice build() {
            return new RejectChoice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RejectChoice> {
        public Builder predictionChoices(Collection<Integer> var1);

        public Builder predictionChoices(Integer ... var1);

        public Builder predictionTarget(String var1);
    }
}

