/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.ManagedPolicyType;
import software.amazon.awssdk.services.datazone.model.PolicyGrantDetail;
import software.amazon.awssdk.services.datazone.model.PolicyGrantPrincipal;
import software.amazon.awssdk.services.datazone.model.TargetEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddPolicyGrantRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, AddPolicyGrantRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::clientToken)).setter(AddPolicyGrantRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<PolicyGrantDetail> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detail").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::detail)).setter(AddPolicyGrantRequest.setter(Builder::detail)).constructor(PolicyGrantDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::domainIdentifier)).setter(AddPolicyGrantRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdentifier").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::entityIdentifier)).setter(AddPolicyGrantRequest.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::entityTypeAsString)).setter(AddPolicyGrantRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::policyTypeAsString)).setter(AddPolicyGrantRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<PolicyGrantPrincipal> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(AddPolicyGrantRequest.getter(AddPolicyGrantRequest::principal)).setter(AddPolicyGrantRequest.setter(Builder::principal)).constructor(PolicyGrantPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DETAIL_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, POLICY_TYPE_FIELD, PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("detail", DETAIL_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
            this.put("entityType", ENTITY_TYPE_FIELD);
            this.put("policyType", POLICY_TYPE_FIELD);
            this.put("principal", PRINCIPAL_FIELD);
        }
    });
    private final String clientToken;
    private final PolicyGrantDetail detail;
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityType;
    private final String policyType;
    private final PolicyGrantPrincipal principal;

    private AddPolicyGrantRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.detail = builder.detail;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.policyType = builder.policyType;
        this.principal = builder.principal;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final PolicyGrantDetail detail() {
        return this.detail;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final TargetEntityType entityType() {
        return TargetEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final ManagedPolicyType policyType() {
        return ManagedPolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final PolicyGrantPrincipal principal() {
        return this.principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPolicyGrantRequest)) {
            return false;
        }
        AddPolicyGrantRequest other = (AddPolicyGrantRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.principal(), other.principal());
    }

    public final String toString() {
        return ToString.builder((String)"AddPolicyGrantRequest").add("ClientToken", (Object)this.clientToken()).add("Detail", (Object)this.detail()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityType", (Object)this.entityTypeAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("Principal", (Object)this.principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddPolicyGrantRequest, T> g) {
        return obj -> g.apply((AddPolicyGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private PolicyGrantDetail detail;
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityType;
        private String policyType;
        private PolicyGrantPrincipal principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPolicyGrantRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.detail(model.detail);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityType(model.entityType);
            this.policyType(model.policyType);
            this.principal(model.principal);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final PolicyGrantDetail.Builder getDetail() {
            return this.detail != null ? this.detail.toBuilder() : null;
        }

        public final void setDetail(PolicyGrantDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(PolicyGrantDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TargetEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(ManagedPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final PolicyGrantPrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(PolicyGrantPrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(PolicyGrantPrincipal principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPolicyGrantRequest build() {
            return new AddPolicyGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddPolicyGrantRequest> {
        public Builder clientToken(String var1);

        public Builder detail(PolicyGrantDetail var1);

        default public Builder detail(Consumer<PolicyGrantDetail.Builder> detail) {
            return this.detail((PolicyGrantDetail)((PolicyGrantDetail.Builder)PolicyGrantDetail.builder().applyMutation(detail)).build());
        }

        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityType(String var1);

        public Builder entityType(TargetEntityType var1);

        public Builder policyType(String var1);

        public Builder policyType(ManagedPolicyType var1);

        public Builder principal(PolicyGrantPrincipal var1);

        default public Builder principal(Consumer<PolicyGrantPrincipal.Builder> principal) {
            return this.principal((PolicyGrantPrincipal)((PolicyGrantPrincipal.Builder)PolicyGrantPrincipal.builder().applyMutation(principal)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

