/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.datazone.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalConnectionRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalConnectionRequirements> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::availabilityZone)).setter(PhysicalConnectionRequirements.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIdList").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::securityGroupIdList)).setter(PhysicalConnectionRequirements.setter(Builder::securityGroupIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnetId").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::subnetId)).setter(PhysicalConnectionRequirements.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<List<String>> SUBNET_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIdList").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::subnetIdList)).setter(PhysicalConnectionRequirements.setter(Builder::subnetIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, SECURITY_GROUP_ID_LIST_FIELD, SUBNET_ID_FIELD, SUBNET_ID_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhysicalConnectionRequirements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final List<String> securityGroupIdList;
    private final String subnetId;
    private final List<String> subnetIdList;

    private PhysicalConnectionRequirements(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.securityGroupIdList = builder.securityGroupIdList;
        this.subnetId = builder.subnetId;
        this.subnetIdList = builder.subnetIdList;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasSecurityGroupIdList() {
        return this.securityGroupIdList != null && !(this.securityGroupIdList instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIdList() {
        return this.securityGroupIdList;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSubnetIdList() {
        return this.subnetIdList != null && !(this.subnetIdList instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIdList() {
        return this.subnetIdList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIdList() ? this.subnetIdList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalConnectionRequirements)) {
            return false;
        }
        PhysicalConnectionRequirements other = (PhysicalConnectionRequirements)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasSecurityGroupIdList() == other.hasSecurityGroupIdList() && Objects.equals(this.securityGroupIdList(), other.securityGroupIdList()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasSubnetIdList() == other.hasSubnetIdList() && Objects.equals(this.subnetIdList(), other.subnetIdList());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalConnectionRequirements").add("AvailabilityZone", (Object)this.availabilityZone()).add("SecurityGroupIdList", this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null).add("SubnetId", (Object)this.subnetId()).add("SubnetIdList", this.hasSubnetIdList() ? this.subnetIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "securityGroupIdList": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdList()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "subnetIdList": {
                return Optional.ofNullable(clazz.cast(this.subnetIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("securityGroupIdList", SECURITY_GROUP_ID_LIST_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("subnetIdList", SUBNET_ID_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalConnectionRequirements, T> g) {
        return obj -> g.apply((PhysicalConnectionRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private List<String> subnetIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalConnectionRequirements model) {
            this.availabilityZone(model.availabilityZone);
            this.securityGroupIdList(model.securityGroupIdList);
            this.subnetId(model.subnetId);
            this.subnetIdList(model.subnetIdList);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (this.securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIdList;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String ... securityGroupIdList) {
            this.securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSubnetIdList() {
            if (this.subnetIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIdList;
        }

        public final void setSubnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
        }

        @Override
        public final Builder subnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIdList(String ... subnetIdList) {
            this.subnetIdList(Arrays.asList(subnetIdList));
            return this;
        }

        public PhysicalConnectionRequirements build() {
            return new PhysicalConnectionRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalConnectionRequirements> {
        public Builder availabilityZone(String var1);

        public Builder securityGroupIdList(Collection<String> var1);

        public Builder securityGroupIdList(String ... var1);

        public Builder subnetId(String var1);

        public Builder subnetIdList(Collection<String> var1);

        public Builder subnetIdList(String ... var1);
    }
}

