/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnvironmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListEnvironmentsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::awsAccountId)).setter(ListEnvironmentsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountRegion").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::awsAccountRegion)).setter(ListEnvironmentsRequest.setter(Builder::awsAccountRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountRegion").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::domainIdentifier)).setter(ListEnvironmentsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentBlueprintIdentifier").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::environmentBlueprintIdentifier)).setter(ListEnvironmentsRequest.setter(Builder::environmentBlueprintIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentBlueprintIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_PROFILE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentProfileIdentifier").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::environmentProfileIdentifier)).setter(ListEnvironmentsRequest.setter(Builder::environmentProfileIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentProfileIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::maxResults)).setter(ListEnvironmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::name)).setter(ListEnvironmentsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::nextToken)).setter(ListEnvironmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectIdentifier").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::projectIdentifier)).setter(ListEnvironmentsRequest.setter(Builder::projectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::provider)).setter(ListEnvironmentsRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("provider").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListEnvironmentsRequest.getter(ListEnvironmentsRequest::statusAsString)).setter(ListEnvironmentsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_REGION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, ENVIRONMENT_PROFILE_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD, PROVIDER_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentsRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String awsAccountRegion;
    private final String domainIdentifier;
    private final String environmentBlueprintIdentifier;
    private final String environmentProfileIdentifier;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final String projectIdentifier;
    private final String provider;
    private final String status;

    private ListEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.environmentProfileIdentifier = builder.environmentProfileIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
        this.provider = builder.provider;
        this.status = builder.status;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsAccountRegion() {
        return this.awsAccountRegion;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentBlueprintIdentifier() {
        return this.environmentBlueprintIdentifier;
    }

    public final String environmentProfileIdentifier() {
        return this.environmentProfileIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    public final String provider() {
        return this.provider;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsRequest)) {
            return false;
        }
        ListEnvironmentsRequest other = (ListEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier()) && Objects.equals(this.environmentProfileIdentifier(), other.environmentProfileIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AwsAccountRegion", (Object)this.awsAccountRegion()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentBlueprintIdentifier", (Object)this.environmentBlueprintIdentifier()).add("EnvironmentProfileIdentifier", (Object)this.environmentProfileIdentifier()).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)this.name()).add("NextToken", (Object)this.nextToken()).add("ProjectIdentifier", (Object)this.projectIdentifier()).add("Provider", (Object)this.provider()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsAccountRegion": {
                return Optional.ofNullable(clazz.cast(this.awsAccountRegion()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentBlueprintIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintIdentifier()));
            }
            case "environmentProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentProfileIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
        map.put("environmentProfileIdentifier", ENVIRONMENT_PROFILE_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsAccountRegion;
        private String domainIdentifier;
        private String environmentBlueprintIdentifier;
        private String environmentProfileIdentifier;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private String projectIdentifier;
        private String provider;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.awsAccountRegion(model.awsAccountRegion);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            this.environmentProfileIdentifier(model.environmentProfileIdentifier);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.projectIdentifier(model.projectIdentifier);
            this.provider(model.provider);
            this.status(model.status);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return this.awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return this.environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getEnvironmentProfileIdentifier() {
            return this.environmentProfileIdentifier;
        }

        public final void setEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
        }

        @Override
        public final Builder environmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentsRequest build() {
            return new ListEnvironmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentsRequest> {
        public Builder awsAccountId(String var1);

        public Builder awsAccountRegion(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentBlueprintIdentifier(String var1);

        public Builder environmentProfileIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder projectIdentifier(String var1);

        public Builder provider(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

