/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationsListCopier;
import software.amazon.awssdk.services.datazone.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectProfileRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateProjectProfileRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::description)).setter(UpdateProjectProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::domainIdentifier)).setter(UpdateProjectProfileRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_UNIT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainUnitIdentifier").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::domainUnitIdentifier)).setter(UpdateProjectProfileRequest.setter(Builder::domainUnitIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitIdentifier").build()}).build();
    private static final SdkField<List<EnvironmentConfiguration>> ENVIRONMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentConfigurations").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::environmentConfigurations)).setter(UpdateProjectProfileRequest.setter(Builder::environmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::identifier)).setter(UpdateProjectProfileRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::name)).setter(UpdateProjectProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateProjectProfileRequest.getter(UpdateProjectProfileRequest::statusAsString)).setter(UpdateProjectProfileRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, DOMAIN_UNIT_IDENTIFIER_FIELD, ENVIRONMENT_CONFIGURATIONS_FIELD, IDENTIFIER_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("domainUnitIdentifier", DOMAIN_UNIT_IDENTIFIER_FIELD);
            this.put("environmentConfigurations", ENVIRONMENT_CONFIGURATIONS_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String description;
    private final String domainIdentifier;
    private final String domainUnitIdentifier;
    private final List<EnvironmentConfiguration> environmentConfigurations;
    private final String identifier;
    private final String name;
    private final String status;

    private UpdateProjectProfileRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.domainUnitIdentifier = builder.domainUnitIdentifier;
        this.environmentConfigurations = builder.environmentConfigurations;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String domainUnitIdentifier() {
        return this.domainUnitIdentifier;
    }

    public final boolean hasEnvironmentConfigurations() {
        return this.environmentConfigurations != null && !(this.environmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentConfiguration> environmentConfigurations() {
        return this.environmentConfigurations;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentConfigurations() ? this.environmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectProfileRequest)) {
            return false;
        }
        UpdateProjectProfileRequest other = (UpdateProjectProfileRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.domainUnitIdentifier(), other.domainUnitIdentifier()) && this.hasEnvironmentConfigurations() == other.hasEnvironmentConfigurations() && Objects.equals(this.environmentConfigurations(), other.environmentConfigurations()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectProfileRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("DomainUnitIdentifier", (Object)this.domainUnitIdentifier()).add("EnvironmentConfigurations", this.hasEnvironmentConfigurations() ? this.environmentConfigurations() : null).add("Identifier", (Object)this.identifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "domainUnitIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainUnitIdentifier()));
            }
            case "environmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.environmentConfigurations()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectProfileRequest, T> g) {
        return obj -> g.apply((UpdateProjectProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private String domainUnitIdentifier;
        private List<EnvironmentConfiguration> environmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectProfileRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.domainUnitIdentifier(model.domainUnitIdentifier);
            this.environmentConfigurations(model.environmentConfigurations);
            this.identifier(model.identifier);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getDomainUnitIdentifier() {
            return this.domainUnitIdentifier;
        }

        public final void setDomainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
        }

        @Override
        public final Builder domainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
            return this;
        }

        public final List<EnvironmentConfiguration.Builder> getEnvironmentConfigurations() {
            List<EnvironmentConfiguration.Builder> result = EnvironmentConfigurationsListCopier.copyToBuilder(this.environmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentConfigurations(Collection<EnvironmentConfiguration.BuilderImpl> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copyFromBuilder(environmentConfigurations);
        }

        @Override
        public final Builder environmentConfigurations(Collection<EnvironmentConfiguration> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copy(environmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(EnvironmentConfiguration ... environmentConfigurations) {
            this.environmentConfigurations(Arrays.asList(environmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder> ... environmentConfigurations) {
            this.environmentConfigurations(Stream.of(environmentConfigurations).map(c -> (EnvironmentConfiguration)((EnvironmentConfiguration.Builder)EnvironmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectProfileRequest build() {
            return new UpdateProjectProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectProfileRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder domainUnitIdentifier(String var1);

        public Builder environmentConfigurations(Collection<EnvironmentConfiguration> var1);

        public Builder environmentConfigurations(EnvironmentConfiguration ... var1);

        public Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder> ... var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

