/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.LineageEventProcessingStatus;
import software.amazon.awssdk.services.datazone.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLineageEventsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListLineageEventsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::domainIdentifier)).setter(ListLineageEventsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::maxResults)).setter(ListLineageEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::nextToken)).setter(ListLineageEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processingStatus").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::processingStatusAsString)).setter(ListLineageEventsRequest.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("processingStatus").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::sortOrderAsString)).setter(ListLineageEventsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestampAfter").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::timestampAfter)).setter(ListLineageEventsRequest.setter(Builder::timestampAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampAfter").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestampBefore").getter(ListLineageEventsRequest.getter(ListLineageEventsRequest::timestampBefore)).setter(ListLineageEventsRequest.setter(Builder::timestampBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampBefore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROCESSING_STATUS_FIELD, SORT_ORDER_FIELD, TIMESTAMP_AFTER_FIELD, TIMESTAMP_BEFORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("processingStatus", PROCESSING_STATUS_FIELD);
            this.put("sortOrder", SORT_ORDER_FIELD);
            this.put("timestampAfter", TIMESTAMP_AFTER_FIELD);
            this.put("timestampBefore", TIMESTAMP_BEFORE_FIELD);
        }
    });
    private final String domainIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final String processingStatus;
    private final String sortOrder;
    private final Instant timestampAfter;
    private final Instant timestampBefore;

    private ListLineageEventsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.processingStatus = builder.processingStatus;
        this.sortOrder = builder.sortOrder;
        this.timestampAfter = builder.timestampAfter;
        this.timestampBefore = builder.timestampBefore;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final LineageEventProcessingStatus processingStatus() {
        return LineageEventProcessingStatus.fromValue(this.processingStatus);
    }

    public final String processingStatusAsString() {
        return this.processingStatus;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Instant timestampAfter() {
        return this.timestampAfter;
    }

    public final Instant timestampBefore() {
        return this.timestampBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampBefore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageEventsRequest)) {
            return false;
        }
        ListLineageEventsRequest other = (ListLineageEventsRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.processingStatusAsString(), other.processingStatusAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.timestampAfter(), other.timestampAfter()) && Objects.equals(this.timestampBefore(), other.timestampBefore());
    }

    public final String toString() {
        return ToString.builder((String)"ListLineageEventsRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ProcessingStatus", (Object)this.processingStatusAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("TimestampAfter", (Object)this.timestampAfter()).add("TimestampBefore", (Object)this.timestampBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "processingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatusAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "timestampAfter": {
                return Optional.ofNullable(clazz.cast(this.timestampAfter()));
            }
            case "timestampBefore": {
                return Optional.ofNullable(clazz.cast(this.timestampBefore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLineageEventsRequest, T> g) {
        return obj -> g.apply((ListLineageEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private Integer maxResults;
        private String nextToken;
        private String processingStatus;
        private String sortOrder;
        private Instant timestampAfter;
        private Instant timestampBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageEventsRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.processingStatus(model.processingStatus);
            this.sortOrder(model.sortOrder);
            this.timestampAfter(model.timestampAfter);
            this.timestampBefore(model.timestampBefore);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(LineageEventProcessingStatus processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Instant getTimestampAfter() {
            return this.timestampAfter;
        }

        public final void setTimestampAfter(Instant timestampAfter) {
            this.timestampAfter = timestampAfter;
        }

        @Override
        public final Builder timestampAfter(Instant timestampAfter) {
            this.timestampAfter = timestampAfter;
            return this;
        }

        public final Instant getTimestampBefore() {
            return this.timestampBefore;
        }

        public final void setTimestampBefore(Instant timestampBefore) {
            this.timestampBefore = timestampBefore;
        }

        @Override
        public final Builder timestampBefore(Instant timestampBefore) {
            this.timestampBefore = timestampBefore;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLineageEventsRequest build() {
            return new ListLineageEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLineageEventsRequest> {
        public Builder domainIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder processingStatus(String var1);

        public Builder processingStatus(LineageEventProcessingStatus var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder timestampAfter(Instant var1);

        public Builder timestampBefore(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

