/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.PolicyGrantListCopier;
import software.amazon.awssdk.services.datazone.model.PolicyGrantMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyGrantsResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, ListPolicyGrantsResponse> {
    private static final SdkField<List<PolicyGrantMember>> GRANT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grantList").getter(ListPolicyGrantsResponse.getter(ListPolicyGrantsResponse::grantList)).setter(ListPolicyGrantsResponse.setter(Builder::grantList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyGrantMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyGrantsResponse.getter(ListPolicyGrantsResponse::nextToken)).setter(ListPolicyGrantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("grantList", GRANT_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PolicyGrantMember> grantList;
    private final String nextToken;

    private ListPolicyGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.grantList = builder.grantList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGrantList() {
        return this.grantList != null && !(this.grantList instanceof SdkAutoConstructList);
    }

    public final List<PolicyGrantMember> grantList() {
        return this.grantList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantList() ? this.grantList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGrantsResponse)) {
            return false;
        }
        ListPolicyGrantsResponse other = (ListPolicyGrantsResponse)((Object)obj);
        return this.hasGrantList() == other.hasGrantList() && Objects.equals(this.grantList(), other.grantList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyGrantsResponse").add("GrantList", this.hasGrantList() ? this.grantList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grantList": {
                return Optional.ofNullable(clazz.cast(this.grantList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGrantsResponse, T> g) {
        return obj -> g.apply((ListPolicyGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<PolicyGrantMember> grantList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGrantsResponse model) {
            super(model);
            this.grantList(model.grantList);
            this.nextToken(model.nextToken);
        }

        public final List<PolicyGrantMember.Builder> getGrantList() {
            List<PolicyGrantMember.Builder> result = PolicyGrantListCopier.copyToBuilder(this.grantList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantList(Collection<PolicyGrantMember.BuilderImpl> grantList) {
            this.grantList = PolicyGrantListCopier.copyFromBuilder(grantList);
        }

        @Override
        public final Builder grantList(Collection<PolicyGrantMember> grantList) {
            this.grantList = PolicyGrantListCopier.copy(grantList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantList(PolicyGrantMember ... grantList) {
            this.grantList(Arrays.asList(grantList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantList(Consumer<PolicyGrantMember.Builder> ... grantList) {
            this.grantList(Stream.of(grantList).map(c -> (PolicyGrantMember)((PolicyGrantMember.Builder)PolicyGrantMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyGrantsResponse build() {
            return new ListPolicyGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyGrantsResponse> {
        public Builder grantList(Collection<PolicyGrantMember> var1);

        public Builder grantList(PolicyGrantMember ... var1);

        public Builder grantList(Consumer<PolicyGrantMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

