/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataProductListingItemAdditionalAttributes;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.ListingSummaryItem;
import software.amazon.awssdk.services.datazone.model.ListingSummaryItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductListingItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductListingItem> {
    private static final SdkField<DataProductListingItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalAttributes").getter(DataProductListingItem.getter(DataProductListingItem::additionalAttributes)).setter(DataProductListingItem.setter(Builder::additionalAttributes)).constructor(DataProductListingItemAdditionalAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataProductListingItem.getter(DataProductListingItem::createdAt)).setter(DataProductListingItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DataProductListingItem.getter(DataProductListingItem::description)).setter(DataProductListingItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(DataProductListingItem.getter(DataProductListingItem::entityId)).setter(DataProductListingItem.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityRevision").getter(DataProductListingItem.getter(DataProductListingItem::entityRevision)).setter(DataProductListingItem.setter(Builder::entityRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()}).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(DataProductListingItem.getter(DataProductListingItem::glossaryTerms)).setter(DataProductListingItem.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ListingSummaryItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(DataProductListingItem.getter(DataProductListingItem::items)).setter(DataProductListingItem.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListingSummaryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LISTING_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingCreatedBy").getter(DataProductListingItem.getter(DataProductListingItem::listingCreatedBy)).setter(DataProductListingItem.setter(Builder::listingCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingCreatedBy").build()}).build();
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingId").getter(DataProductListingItem.getter(DataProductListingItem::listingId)).setter(DataProductListingItem.setter(Builder::listingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()}).build();
    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingRevision").getter(DataProductListingItem.getter(DataProductListingItem::listingRevision)).setter(DataProductListingItem.setter(Builder::listingRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()}).build();
    private static final SdkField<String> LISTING_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingUpdatedBy").getter(DataProductListingItem.getter(DataProductListingItem::listingUpdatedBy)).setter(DataProductListingItem.setter(Builder::listingUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingUpdatedBy").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataProductListingItem.getter(DataProductListingItem::name)).setter(DataProductListingItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(DataProductListingItem.getter(DataProductListingItem::owningProjectId)).setter(DataProductListingItem.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, GLOSSARY_TERMS_FIELD, ITEMS_FIELD, LISTING_CREATED_BY_FIELD, LISTING_ID_FIELD, LISTING_REVISION_FIELD, LISTING_UPDATED_BY_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataProductListingItemAdditionalAttributes additionalAttributes;
    private final Instant createdAt;
    private final String description;
    private final String entityId;
    private final String entityRevision;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final List<ListingSummaryItem> items;
    private final String listingCreatedBy;
    private final String listingId;
    private final String listingRevision;
    private final String listingUpdatedBy;
    private final String name;
    private final String owningProjectId;

    private DataProductListingItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.glossaryTerms = builder.glossaryTerms;
        this.items = builder.items;
        this.listingCreatedBy = builder.listingCreatedBy;
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.listingUpdatedBy = builder.listingUpdatedBy;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
    }

    public final DataProductListingItemAdditionalAttributes additionalAttributes() {
        return this.additionalAttributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ListingSummaryItem> items() {
        return this.items;
    }

    public final String listingCreatedBy() {
        return this.listingCreatedBy;
    }

    public final String listingId() {
        return this.listingId;
    }

    public final String listingRevision() {
        return this.listingRevision;
    }

    public final String listingUpdatedBy() {
        return this.listingUpdatedBy;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listingCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductListingItem)) {
            return false;
        }
        DataProductListingItem other = (DataProductListingItem)obj;
        return Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityRevision(), other.entityRevision()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.listingCreatedBy(), other.listingCreatedBy()) && Objects.equals(this.listingId(), other.listingId()) && Objects.equals(this.listingRevision(), other.listingRevision()) && Objects.equals(this.listingUpdatedBy(), other.listingUpdatedBy()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductListingItem").add("AdditionalAttributes", (Object)this.additionalAttributes()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EntityId", (Object)this.entityId()).add("EntityRevision", (Object)this.entityRevision()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Items", this.hasItems() ? this.items() : null).add("ListingCreatedBy", (Object)this.listingCreatedBy()).add("ListingId", (Object)this.listingId()).add("ListingRevision", (Object)this.listingRevision()).add("ListingUpdatedBy", (Object)this.listingUpdatedBy()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectId", (Object)this.owningProjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "listingCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.listingCreatedBy()));
            }
            case "listingId": {
                return Optional.ofNullable(clazz.cast(this.listingId()));
            }
            case "listingRevision": {
                return Optional.ofNullable(clazz.cast(this.listingRevision()));
            }
            case "listingUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.listingUpdatedBy()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductListingItem, T> g) {
        return obj -> g.apply((DataProductListingItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataProductListingItemAdditionalAttributes additionalAttributes;
        private Instant createdAt;
        private String description;
        private String entityId;
        private String entityRevision;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private List<ListingSummaryItem> items = DefaultSdkAutoConstructList.getInstance();
        private String listingCreatedBy;
        private String listingId;
        private String listingRevision;
        private String listingUpdatedBy;
        private String name;
        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductListingItem model) {
            this.additionalAttributes(model.additionalAttributes);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.entityId(model.entityId);
            this.entityRevision(model.entityRevision);
            this.glossaryTerms(model.glossaryTerms);
            this.items(model.items);
            this.listingCreatedBy(model.listingCreatedBy);
            this.listingId(model.listingId);
            this.listingRevision(model.listingRevision);
            this.listingUpdatedBy(model.listingUpdatedBy);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
        }

        public final DataProductListingItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return this.additionalAttributes != null ? this.additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(DataProductListingItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(DataProductListingItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListingSummaryItem.Builder> getItems() {
            List<ListingSummaryItem.Builder> result = ListingSummaryItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListingSummaryItem.BuilderImpl> items) {
            this.items = ListingSummaryItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListingSummaryItem> items) {
            this.items = ListingSummaryItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListingSummaryItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListingSummaryItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ListingSummaryItem)((ListingSummaryItem.Builder)ListingSummaryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getListingCreatedBy() {
            return this.listingCreatedBy;
        }

        public final void setListingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
        }

        @Override
        public final Builder listingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
            return this;
        }

        public final String getListingId() {
            return this.listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return this.listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getListingUpdatedBy() {
            return this.listingUpdatedBy;
        }

        public final void setListingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
        }

        @Override
        public final Builder listingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public DataProductListingItem build() {
            return new DataProductListingItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductListingItem> {
        public Builder additionalAttributes(DataProductListingItemAdditionalAttributes var1);

        default public Builder additionalAttributes(Consumer<DataProductListingItemAdditionalAttributes.Builder> additionalAttributes) {
            return this.additionalAttributes((DataProductListingItemAdditionalAttributes)((DataProductListingItemAdditionalAttributes.Builder)DataProductListingItemAdditionalAttributes.builder().applyMutation(additionalAttributes)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder entityId(String var1);

        public Builder entityRevision(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder items(Collection<ListingSummaryItem> var1);

        public Builder items(ListingSummaryItem ... var1);

        public Builder items(Consumer<ListingSummaryItem.Builder> ... var1);

        public Builder listingCreatedBy(String var1);

        public Builder listingId(String var1);

        public Builder listingRevision(String var1);

        public Builder listingUpdatedBy(String var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);
    }
}

