/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetListingItemAdditionalAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetListingItemAdditionalAttributes> {
    private static final SdkField<String> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("forms").getter(AssetListingItemAdditionalAttributes.getter(AssetListingItemAdditionalAttributes::forms)).setter(AssetListingItemAdditionalAttributes.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()}).build();
    private static final SdkField<List<TimeSeriesDataPointSummaryFormOutput>> LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("latestTimeSeriesDataPointForms").getter(AssetListingItemAdditionalAttributes.getter(AssetListingItemAdditionalAttributes::latestTimeSeriesDataPointForms)).setter(AssetListingItemAdditionalAttributes.setter(Builder::latestTimeSeriesDataPointForms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestTimeSeriesDataPointForms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesDataPointSummaryFormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMS_FIELD, LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String forms;
    private final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms;

    private AssetListingItemAdditionalAttributes(BuilderImpl builder) {
        this.forms = builder.forms;
        this.latestTimeSeriesDataPointForms = builder.latestTimeSeriesDataPointForms;
    }

    public final String forms() {
        return this.forms;
    }

    public final boolean hasLatestTimeSeriesDataPointForms() {
        return this.latestTimeSeriesDataPointForms != null && !(this.latestTimeSeriesDataPointForms instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms() {
        return this.latestTimeSeriesDataPointForms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forms());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestTimeSeriesDataPointForms() ? this.latestTimeSeriesDataPointForms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListingItemAdditionalAttributes)) {
            return false;
        }
        AssetListingItemAdditionalAttributes other = (AssetListingItemAdditionalAttributes)obj;
        return Objects.equals(this.forms(), other.forms()) && this.hasLatestTimeSeriesDataPointForms() == other.hasLatestTimeSeriesDataPointForms() && Objects.equals(this.latestTimeSeriesDataPointForms(), other.latestTimeSeriesDataPointForms());
    }

    public final String toString() {
        return ToString.builder((String)"AssetListingItemAdditionalAttributes").add("Forms", (Object)this.forms()).add("LatestTimeSeriesDataPointForms", this.hasLatestTimeSeriesDataPointForms() ? this.latestTimeSeriesDataPointForms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
            case "latestTimeSeriesDataPointForms": {
                return Optional.ofNullable(clazz.cast(this.latestTimeSeriesDataPointForms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetListingItemAdditionalAttributes, T> g) {
        return obj -> g.apply((AssetListingItemAdditionalAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String forms;
        private List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListingItemAdditionalAttributes model) {
            this.forms(model.forms);
            this.latestTimeSeriesDataPointForms(model.latestTimeSeriesDataPointForms);
        }

        public final String getForms() {
            return this.forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<TimeSeriesDataPointSummaryFormOutput.Builder> getLatestTimeSeriesDataPointForms() {
            List<TimeSeriesDataPointSummaryFormOutput.Builder> result = TimeSeriesDataPointSummaryFormOutputListCopier.copyToBuilder(this.latestTimeSeriesDataPointForms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput.BuilderImpl> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier.copyFromBuilder(latestTimeSeriesDataPointForms);
        }

        @Override
        public final Builder latestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier.copy(latestTimeSeriesDataPointForms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(TimeSeriesDataPointSummaryFormOutput ... latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms(Arrays.asList(latestTimeSeriesDataPointForms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms(Stream.of(latestTimeSeriesDataPointForms).map(c -> (TimeSeriesDataPointSummaryFormOutput)((TimeSeriesDataPointSummaryFormOutput.Builder)TimeSeriesDataPointSummaryFormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetListingItemAdditionalAttributes build() {
            return new AssetListingItemAdditionalAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetListingItemAdditionalAttributes> {
        public Builder forms(String var1);

        public Builder latestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput> var1);

        public Builder latestTimeSeriesDataPointForms(TimeSeriesDataPointSummaryFormOutput ... var1);

        public Builder latestTimeSeriesDataPointForms(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... var1);
    }
}

