/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataProductRevision;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse;

public class ListDataProductRevisionsPublisher
implements SdkPublisher<ListDataProductRevisionsResponse> {
    private final DataZoneAsyncClient client;
    private final ListDataProductRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataProductRevisionsPublisher(DataZoneAsyncClient client, ListDataProductRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataProductRevisionsPublisher(DataZoneAsyncClient client, ListDataProductRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataProductRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataProductRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataProductRevision> items() {
        Function<ListDataProductRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataProductRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataProductRevisionsResponseFetcher
    implements AsyncPageFetcher<ListDataProductRevisionsResponse> {
        private ListDataProductRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataProductRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataProductRevisionsResponse> nextPage(ListDataProductRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataProductRevisionsPublisher.this.client.listDataProductRevisions(ListDataProductRevisionsPublisher.this.firstRequest);
            }
            return ListDataProductRevisionsPublisher.this.client.listDataProductRevisions((ListDataProductRevisionsRequest)((Object)ListDataProductRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

