/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FormTypeStatus;
import software.amazon.awssdk.services.datazone.model.Import;
import software.amazon.awssdk.services.datazone.model.ImportListCopier;
import software.amazon.awssdk.services.datazone.model.Model;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFormTypeResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetFormTypeResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetFormTypeResponse.getter(GetFormTypeResponse::createdAt)).setter(GetFormTypeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetFormTypeResponse.getter(GetFormTypeResponse::createdBy)).setter(GetFormTypeResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetFormTypeResponse.getter(GetFormTypeResponse::description)).setter(GetFormTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetFormTypeResponse.getter(GetFormTypeResponse::domainId)).setter(GetFormTypeResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<List<Import>> IMPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imports").getter(GetFormTypeResponse.getter(GetFormTypeResponse::imports)).setter(GetFormTypeResponse.setter(Builder::imports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Import::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Model> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("model").getter(GetFormTypeResponse.getter(GetFormTypeResponse::model)).setter(GetFormTypeResponse.setter(Builder::model)).constructor(Model::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetFormTypeResponse.getter(GetFormTypeResponse::name)).setter(GetFormTypeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ORIGIN_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originDomainId").getter(GetFormTypeResponse.getter(GetFormTypeResponse::originDomainId)).setter(GetFormTypeResponse.setter(Builder::originDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originDomainId").build()}).build();
    private static final SdkField<String> ORIGIN_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originProjectId").getter(GetFormTypeResponse.getter(GetFormTypeResponse::originProjectId)).setter(GetFormTypeResponse.setter(Builder::originProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originProjectId").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(GetFormTypeResponse.getter(GetFormTypeResponse::owningProjectId)).setter(GetFormTypeResponse.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(GetFormTypeResponse.getter(GetFormTypeResponse::revision)).setter(GetFormTypeResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFormTypeResponse.getter(GetFormTypeResponse::statusAsString)).setter(GetFormTypeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, IMPORTS_FIELD, MODEL_FIELD, NAME_FIELD, ORIGIN_DOMAIN_ID_FIELD, ORIGIN_PROJECT_ID_FIELD, OWNING_PROJECT_ID_FIELD, REVISION_FIELD, STATUS_FIELD));
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final List<Import> imports;
    private final Model model;
    private final String name;
    private final String originDomainId;
    private final String originProjectId;
    private final String owningProjectId;
    private final String revision;
    private final String status;

    private GetFormTypeResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.imports = builder.imports;
        this.model = builder.model;
        this.name = builder.name;
        this.originDomainId = builder.originDomainId;
        this.originProjectId = builder.originProjectId;
        this.owningProjectId = builder.owningProjectId;
        this.revision = builder.revision;
        this.status = builder.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasImports() {
        return this.imports != null && !(this.imports instanceof SdkAutoConstructList);
    }

    public final List<Import> imports() {
        return this.imports;
    }

    public final Model model() {
        return this.model;
    }

    public final String name() {
        return this.name;
    }

    public final String originDomainId() {
        return this.originDomainId;
    }

    public final String originProjectId() {
        return this.originProjectId;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String revision() {
        return this.revision;
    }

    public final FormTypeStatus status() {
        return FormTypeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImports() ? this.imports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFormTypeResponse)) {
            return false;
        }
        GetFormTypeResponse other = (GetFormTypeResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasImports() == other.hasImports() && Objects.equals(this.imports(), other.imports()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originDomainId(), other.originDomainId()) && Objects.equals(this.originProjectId(), other.originProjectId()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetFormTypeResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("Imports", this.hasImports() ? this.imports() : null).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OriginDomainId", (Object)this.originDomainId()).add("OriginProjectId", (Object)this.originProjectId()).add("OwningProjectId", (Object)this.owningProjectId()).add("Revision", (Object)this.revision()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "imports": {
                return Optional.ofNullable(clazz.cast(this.imports()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "originDomainId": {
                return Optional.ofNullable(clazz.cast(this.originDomainId()));
            }
            case "originProjectId": {
                return Optional.ofNullable(clazz.cast(this.originProjectId()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFormTypeResponse, T> g) {
        return obj -> g.apply((GetFormTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private List<Import> imports = DefaultSdkAutoConstructList.getInstance();
        private Model model;
        private String name;
        private String originDomainId;
        private String originProjectId;
        private String owningProjectId;
        private String revision;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFormTypeResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.imports(model.imports);
            this.model(model.model);
            this.name(model.name);
            this.originDomainId(model.originDomainId);
            this.originProjectId(model.originProjectId);
            this.owningProjectId(model.owningProjectId);
            this.revision(model.revision);
            this.status(model.status);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<Import.Builder> getImports() {
            List<Import.Builder> result = ImportListCopier.copyToBuilder(this.imports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImports(Collection<Import.BuilderImpl> imports) {
            this.imports = ImportListCopier.copyFromBuilder(imports);
        }

        @Override
        public final Builder imports(Collection<Import> imports) {
            this.imports = ImportListCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(Import ... imports) {
            this.imports(Arrays.asList(imports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(Consumer<Import.Builder> ... imports) {
            this.imports(Stream.of(imports).map(c -> (Import)((Import.Builder)Import.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Model.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        public final void setModel(Model.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(Model model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOriginDomainId() {
            return this.originDomainId;
        }

        public final void setOriginDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
        }

        @Override
        public final Builder originDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
            return this;
        }

        public final String getOriginProjectId() {
            return this.originProjectId;
        }

        public final void setOriginProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
        }

        @Override
        public final Builder originProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FormTypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetFormTypeResponse build() {
            return new GetFormTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFormTypeResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder imports(Collection<Import> var1);

        public Builder imports(Import ... var1);

        public Builder imports(Consumer<Import.Builder> ... var1);

        public Builder model(Model var1);

        default public Builder model(Consumer<Model.Builder> model) {
            return this.model((Model)((Model.Builder)Model.builder().applyMutation(model)).build());
        }

        public Builder name(String var1);

        public Builder originDomainId(String var1);

        public Builder originProjectId(String var1);

        public Builder owningProjectId(String var1);

        public Builder revision(String var1);

        public Builder status(String var1);

        public Builder status(FormTypeStatus var1);
    }
}

