/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductItem> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(DataProductItem.getter(DataProductItem::domainId)).setter(DataProductItem.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(DataProductItem.getter(DataProductItem::itemId)).setter(DataProductItem.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, ITEM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainId;
    private final String itemId;

    private DataProductItem(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.itemId = builder.itemId;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String itemId() {
        return this.itemId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductItem)) {
            return false;
        }
        DataProductItem other = (DataProductItem)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.itemId(), other.itemId());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductItem").add("DomainId", (Object)this.domainId()).add("ItemId", (Object)this.itemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductItem, T> g) {
        return obj -> g.apply((DataProductItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String itemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductItem model) {
            this.domainId(model.domainId);
            this.itemId(model.itemId);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public DataProductItem build() {
            return new DataProductItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductItem> {
        public Builder domainId(String var1);

        public Builder itemId(String var1);
    }
}

