/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointOptions> {
    private static final SdkField<Boolean> FIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EndpointOptions.getter(EndpointOptions::fips)).setter(EndpointOptions.setter(Builder::fips)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fips").build()}).build();
    private static final SdkField<Boolean> PRIVATE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EndpointOptions.getter(EndpointOptions::privateLink)).setter(EndpointOptions.setter(Builder::privateLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLink").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIPS_FIELD, PRIVATE_LINK_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean fips;
    private final Boolean privateLink;

    private EndpointOptions(BuilderImpl builder) {
        this.fips = builder.fips;
        this.privateLink = builder.privateLink;
    }

    public Boolean fips() {
        return this.fips;
    }

    public Boolean privateLink() {
        return this.privateLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fips());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLink());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointOptions)) {
            return false;
        }
        EndpointOptions other = (EndpointOptions)obj;
        return Objects.equals(this.fips(), other.fips()) && Objects.equals(this.privateLink(), other.privateLink());
    }

    public String toString() {
        return ToString.builder((String)"EndpointOptions").add("Fips", (Object)this.fips()).add("PrivateLink", (Object)this.privateLink()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fips": {
                return Optional.ofNullable(clazz.cast(this.fips()));
            }
            case "PrivateLink": {
                return Optional.ofNullable(clazz.cast(this.privateLink()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointOptions, T> g) {
        return obj -> g.apply((EndpointOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean fips;
        private Boolean privateLink;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointOptions model) {
            this.fips(model.fips);
            this.privateLink(model.privateLink);
        }

        public final Boolean getFips() {
            return this.fips;
        }

        @Override
        public final Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public final void setFips(Boolean fips) {
            this.fips = fips;
        }

        public final Boolean getPrivateLink() {
            return this.privateLink;
        }

        @Override
        public final Builder privateLink(Boolean privateLink) {
            this.privateLink = privateLink;
            return this;
        }

        public final void setPrivateLink(Boolean privateLink) {
            this.privateLink = privateLink;
        }

        public EndpointOptions build() {
            return new EndpointOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointOptions> {
        public Builder fips(Boolean var1);

        public Builder privateLink(Boolean var1);
    }
}

