/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.AgentStatus;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.EndpointOptions;
import software.amazon.awssdk.services.datasync.model.PrivateLinkConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeAgentResponse> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAgentResponse.getter(DescribeAgentResponse::agentArn)).setter(DescribeAgentResponse.setter(Builder::agentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAgentResponse.getter(DescribeAgentResponse::name)).setter(DescribeAgentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAgentResponse.getter(DescribeAgentResponse::statusAsString)).setter(DescribeAgentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_CONNECTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeAgentResponse.getter(DescribeAgentResponse::lastConnectionTime)).setter(DescribeAgentResponse.setter(Builder::lastConnectionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeAgentResponse.getter(DescribeAgentResponse::creationTime)).setter(DescribeAgentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<EndpointOptions> ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeAgentResponse.getter(DescribeAgentResponse::endpointOptions)).setter(DescribeAgentResponse.setter(Builder::endpointOptions)).constructor(EndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointOptions").build()}).build();
    private static final SdkField<PrivateLinkConfig> PRIVATE_LINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeAgentResponse.getter(DescribeAgentResponse::privateLinkConfig)).setter(DescribeAgentResponse.setter(Builder::privateLinkConfig)).constructor(PrivateLinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD, STATUS_FIELD, LAST_CONNECTION_TIME_FIELD, CREATION_TIME_FIELD, ENDPOINT_OPTIONS_FIELD, PRIVATE_LINK_CONFIG_FIELD));
    private final String agentArn;
    private final String name;
    private final String status;
    private final Instant lastConnectionTime;
    private final Instant creationTime;
    private final EndpointOptions endpointOptions;
    private final PrivateLinkConfig privateLinkConfig;

    private DescribeAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastConnectionTime = builder.lastConnectionTime;
        this.creationTime = builder.creationTime;
        this.endpointOptions = builder.endpointOptions;
        this.privateLinkConfig = builder.privateLinkConfig;
    }

    public String agentArn() {
        return this.agentArn;
    }

    public String name() {
        return this.name;
    }

    public AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastConnectionTime() {
        return this.lastConnectionTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public EndpointOptions endpointOptions() {
        return this.endpointOptions;
    }

    public PrivateLinkConfig privateLinkConfig() {
        return this.privateLinkConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastConnectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLinkConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentResponse)) {
            return false;
        }
        DescribeAgentResponse other = (DescribeAgentResponse)((Object)obj);
        return Objects.equals(this.agentArn(), other.agentArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastConnectionTime(), other.lastConnectionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endpointOptions(), other.endpointOptions()) && Objects.equals(this.privateLinkConfig(), other.privateLinkConfig());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAgentResponse").add("AgentArn", (Object)this.agentArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("LastConnectionTime", (Object)this.lastConnectionTime()).add("CreationTime", (Object)this.creationTime()).add("EndpointOptions", (Object)this.endpointOptions()).add("PrivateLinkConfig", (Object)this.privateLinkConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentArn": {
                return Optional.ofNullable(clazz.cast(this.agentArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastConnectionTime": {
                return Optional.ofNullable(clazz.cast(this.lastConnectionTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.endpointOptions()));
            }
            case "PrivateLinkConfig": {
                return Optional.ofNullable(clazz.cast(this.privateLinkConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentResponse, T> g) {
        return obj -> g.apply((DescribeAgentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String agentArn;
        private String name;
        private String status;
        private Instant lastConnectionTime;
        private Instant creationTime;
        private EndpointOptions endpointOptions;
        private PrivateLinkConfig privateLinkConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentResponse model) {
            super(model);
            this.agentArn(model.agentArn);
            this.name(model.name);
            this.status(model.status);
            this.lastConnectionTime(model.lastConnectionTime);
            this.creationTime(model.creationTime);
            this.endpointOptions(model.endpointOptions);
            this.privateLinkConfig(model.privateLinkConfig);
        }

        public final String getAgentArn() {
            return this.agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        @Override
        public final Builder lastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
            return this;
        }

        public final void setLastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final EndpointOptions.Builder getEndpointOptions() {
            return this.endpointOptions != null ? this.endpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder endpointOptions(EndpointOptions endpointOptions) {
            this.endpointOptions = endpointOptions;
            return this;
        }

        public final void setEndpointOptions(EndpointOptions.BuilderImpl endpointOptions) {
            this.endpointOptions = endpointOptions != null ? endpointOptions.build() : null;
        }

        public final PrivateLinkConfig.Builder getPrivateLinkConfig() {
            return this.privateLinkConfig != null ? this.privateLinkConfig.toBuilder() : null;
        }

        @Override
        public final Builder privateLinkConfig(PrivateLinkConfig privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig;
            return this;
        }

        public final void setPrivateLinkConfig(PrivateLinkConfig.BuilderImpl privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig != null ? privateLinkConfig.build() : null;
        }

        @Override
        public DescribeAgentResponse build() {
            return new DescribeAgentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAgentResponse> {
        public Builder agentArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);

        public Builder lastConnectionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder endpointOptions(EndpointOptions var1);

        default public Builder endpointOptions(Consumer<EndpointOptions.Builder> endpointOptions) {
            return this.endpointOptions((EndpointOptions)((EndpointOptions.Builder)EndpointOptions.builder().applyMutation(endpointOptions)).build());
        }

        public Builder privateLinkConfig(PrivateLinkConfig var1);

        default public Builder privateLinkConfig(Consumer<PrivateLinkConfig.Builder> privateLinkConfig) {
            return this.privateLinkConfig((PrivateLinkConfig)((PrivateLinkConfig.Builder)PrivateLinkConfig.builder().applyMutation(privateLinkConfig)).build());
        }
    }
}

