/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.CreateAgentRequest;
import software.amazon.awssdk.services.datasync.model.CreateAgentResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Request;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Response;
import software.amazon.awssdk.services.datasync.model.CreateTaskRequest;
import software.amazon.awssdk.services.datasync.model.CreateTaskResponse;
import software.amazon.awssdk.services.datasync.model.DataSyncException;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.DeleteAgentRequest;
import software.amazon.awssdk.services.datasync.model.DeleteAgentResponse;
import software.amazon.awssdk.services.datasync.model.DeleteLocationRequest;
import software.amazon.awssdk.services.datasync.model.DeleteLocationResponse;
import software.amazon.awssdk.services.datasync.model.DeleteTaskRequest;
import software.amazon.awssdk.services.datasync.model.DeleteTaskResponse;
import software.amazon.awssdk.services.datasync.model.DescribeAgentRequest;
import software.amazon.awssdk.services.datasync.model.DescribeAgentResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskResponse;
import software.amazon.awssdk.services.datasync.model.InternalException;
import software.amazon.awssdk.services.datasync.model.InvalidRequestException;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;
import software.amazon.awssdk.services.datasync.model.ListLocationsRequest;
import software.amazon.awssdk.services.datasync.model.ListLocationsResponse;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;
import software.amazon.awssdk.services.datasync.model.ListTasksRequest;
import software.amazon.awssdk.services.datasync.model.ListTasksResponse;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.TagResourceRequest;
import software.amazon.awssdk.services.datasync.model.TagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UntagResourceRequest;
import software.amazon.awssdk.services.datasync.model.UntagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UpdateAgentRequest;
import software.amazon.awssdk.services.datasync.model.UpdateAgentResponse;
import software.amazon.awssdk.services.datasync.model.UpdateTaskRequest;
import software.amazon.awssdk.services.datasync.model.UpdateTaskResponse;
import software.amazon.awssdk.services.datasync.paginators.ListAgentsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListLocationsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsIterable;
import software.amazon.awssdk.services.datasync.paginators.ListTasksIterable;
import software.amazon.awssdk.services.datasync.transform.CancelTaskExecutionRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.CreateAgentRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.CreateLocationEfsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.CreateLocationNfsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.CreateLocationS3RequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.CreateTaskRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DeleteAgentRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DeleteLocationRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DeleteTaskRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeAgentRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeLocationEfsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeLocationNfsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeLocationS3RequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeTaskExecutionRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.DescribeTaskRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.ListAgentsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.ListLocationsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.ListTaskExecutionsRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.ListTasksRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.StartTaskExecutionRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.UpdateAgentRequestMarshaller;
import software.amazon.awssdk.services.datasync.transform.UpdateTaskRequestMarshaller;

@SdkInternalApi
final class DefaultDataSyncClient
implements DataSyncClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDataSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "datasync";
    }

    @Override
    public CancelTaskExecutionResponse cancelTaskExecution(CancelTaskExecutionRequest cancelTaskExecutionRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTaskExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelTaskExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTaskExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelTaskExecutionRequest).withMarshaller((Marshaller)new CancelTaskExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateAgentResponse createAgent(CreateAgentRequest createAgentRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAgent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAgentRequest).withMarshaller((Marshaller)new CreateAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateLocationEfsResponse createLocationEfs(CreateLocationEfsRequest createLocationEfsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLocationEfsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateLocationEfsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLocationEfs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLocationEfsRequest).withMarshaller((Marshaller)new CreateLocationEfsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateLocationNfsResponse createLocationNfs(CreateLocationNfsRequest createLocationNfsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLocationNfsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateLocationNfsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLocationNfs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLocationNfsRequest).withMarshaller((Marshaller)new CreateLocationNfsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateLocationS3Response createLocationS3(CreateLocationS3Request createLocationS3Request) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLocationS3Response::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateLocationS3Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLocationS3").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLocationS3Request).withMarshaller((Marshaller)new CreateLocationS3RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateTaskResponse createTask(CreateTaskRequest createTaskRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTaskRequest).withMarshaller((Marshaller)new CreateTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteAgentResponse deleteAgent(DeleteAgentRequest deleteAgentRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAgent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAgentRequest).withMarshaller((Marshaller)new DeleteAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteLocationResponse deleteLocation(DeleteLocationRequest deleteLocationRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLocationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteLocationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLocation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLocationRequest).withMarshaller((Marshaller)new DeleteLocationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteTaskResponse deleteTask(DeleteTaskRequest deleteTaskRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTaskRequest).withMarshaller((Marshaller)new DeleteTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAgentResponse describeAgent(DescribeAgentRequest describeAgentRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAgent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAgentRequest).withMarshaller((Marshaller)new DescribeAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeLocationEfsResponse describeLocationEfs(DescribeLocationEfsRequest describeLocationEfsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLocationEfsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeLocationEfsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLocationEfs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLocationEfsRequest).withMarshaller((Marshaller)new DescribeLocationEfsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeLocationNfsResponse describeLocationNfs(DescribeLocationNfsRequest describeLocationNfsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLocationNfsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeLocationNfsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLocationNfs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLocationNfsRequest).withMarshaller((Marshaller)new DescribeLocationNfsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeLocationS3Response describeLocationS3(DescribeLocationS3Request describeLocationS3Request) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLocationS3Response::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeLocationS3Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLocationS3").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLocationS3Request).withMarshaller((Marshaller)new DescribeLocationS3RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTaskResponse describeTask(DescribeTaskRequest describeTaskRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTaskRequest).withMarshaller((Marshaller)new DescribeTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTaskExecutionResponse describeTaskExecution(DescribeTaskExecutionRequest describeTaskExecutionRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTaskExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTaskExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTaskExecutionRequest).withMarshaller((Marshaller)new DescribeTaskExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAgentsResponse listAgents(ListAgentsRequest listAgentsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAgentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAgentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAgents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAgentsRequest).withMarshaller((Marshaller)new ListAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAgentsIterable listAgentsPaginator(ListAgentsRequest listAgentsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListAgentsIterable(this, this.applyPaginatorUserAgent(listAgentsRequest));
    }

    @Override
    public ListLocationsResponse listLocations(ListLocationsRequest listLocationsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLocationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListLocationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLocations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLocationsRequest).withMarshaller((Marshaller)new ListLocationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListLocationsIterable listLocationsPaginator(ListLocationsRequest listLocationsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListLocationsIterable(this, this.applyPaginatorUserAgent(listLocationsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public ListTaskExecutionsResponse listTaskExecutions(ListTaskExecutionsRequest listTaskExecutionsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaskExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTaskExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaskExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTaskExecutionsRequest).withMarshaller((Marshaller)new ListTaskExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTaskExecutionsIterable listTaskExecutionsPaginator(ListTaskExecutionsRequest listTaskExecutionsRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTaskExecutionsIterable(this, this.applyPaginatorUserAgent(listTaskExecutionsRequest));
    }

    @Override
    public ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTasksRequest).withMarshaller((Marshaller)new ListTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTasksIterable listTasksPaginator(ListTasksRequest listTasksRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        return new ListTasksIterable(this, this.applyPaginatorUserAgent(listTasksRequest));
    }

    @Override
    public StartTaskExecutionResponse startTaskExecution(StartTaskExecutionRequest startTaskExecutionRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTaskExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartTaskExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTaskExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTaskExecutionRequest).withMarshaller((Marshaller)new StartTaskExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateAgentResponse updateAgent(UpdateAgentRequest updateAgentRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAgent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAgentRequest).withMarshaller((Marshaller)new UpdateAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateTaskResponse updateTask(UpdateTaskRequest updateTaskRequest) throws InvalidRequestException, InternalException, AwsServiceException, SdkClientException, DataSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTaskRequest).withMarshaller((Marshaller)new UpdateTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DataSyncException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DataSyncRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.63").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DataSyncRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

