/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationS3Request extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationS3Request.Builder, UpdateLocationS3Request> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationS3Request::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationS3Request::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> S3_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3StorageClass").getter(getter(UpdateLocationS3Request::s3StorageClassAsString))
            .setter(setter(Builder::s3StorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageClass").build()).build();

    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("S3Config").getter(getter(UpdateLocationS3Request::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SUBDIRECTORY_FIELD, S3_STORAGE_CLASS_FIELD, S3_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String subdirectory;

    private final String s3StorageClass;

    private final S3Config s3Config;

    private UpdateLocationS3Request(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.s3StorageClass = builder.s3StorageClass;
        this.s3Config = builder.s3Config;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Amazon S3 transfer location that you're updating.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the Amazon S3 transfer location that you're updating.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the bucket is a
     * source or destination location).
     * </p>
     * <note>
     * <p>
     * DataSync can't transfer objects with a prefix that begins with a slash (<code>/</code>) or includes
     * <code>//</code>, <code>/./</code>, or <code>/../</code> patterns. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>/photos</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>photos//2006/January</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>photos/./2006/February</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>photos/../2006/March</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the
     *         bucket is a source or destination location).</p> <note>
     *         <p>
     *         DataSync can't transfer objects with a prefix that begins with a slash (<code>/</code>) or includes
     *         <code>//</code>, <code>/./</code>, or <code>/../</code> patterns. For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>/photos</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>photos//2006/January</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>photos/./2006/February</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>photos/../2006/March</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
     * </p>
     * <p>
     * For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For buckets on
     * Outposts, the storage class defaults to <code>OUTPOSTS</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     * >Storage class considerations with Amazon S3 transfers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return Specifies the storage class that you want your objects to use when Amazon S3 is a transfer
     *         destination.</p>
     *         <p>
     *         For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For
     *         buckets on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     *         >Storage class considerations with Amazon S3 transfers</a>.
     * @see S3StorageClass
     */
    public final S3StorageClass s3StorageClass() {
        return S3StorageClass.fromValue(s3StorageClass);
    }

    /**
     * <p>
     * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
     * </p>
     * <p>
     * For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For buckets on
     * Outposts, the storage class defaults to <code>OUTPOSTS</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     * >Storage class considerations with Amazon S3 transfers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3StorageClass}
     * will return {@link S3StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3StorageClassAsString}.
     * </p>
     * 
     * @return Specifies the storage class that you want your objects to use when Amazon S3 is a transfer
     *         destination.</p>
     *         <p>
     *         For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For
     *         buckets on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
     *         >Storage class considerations with Amazon S3 transfers</a>.
     * @see S3StorageClass
     */
    public final String s3StorageClassAsString() {
        return s3StorageClass;
    }

    /**
     * Returns the value of the S3Config property for this object.
     * 
     * @return The value of the S3Config property for this object.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationS3Request)) {
            return false;
        }
        UpdateLocationS3Request other = (UpdateLocationS3Request) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(s3StorageClassAsString(), other.s3StorageClassAsString())
                && Objects.equals(s3Config(), other.s3Config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationS3Request").add("LocationArn", locationArn()).add("Subdirectory", subdirectory())
                .add("S3StorageClass", s3StorageClassAsString()).add("S3Config", s3Config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "S3StorageClass":
            return Optional.ofNullable(clazz.cast(s3StorageClassAsString()));
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("S3StorageClass", S3_STORAGE_CLASS_FIELD);
        map.put("S3Config", S3_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationS3Request, T> g) {
        return obj -> g.apply((UpdateLocationS3Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationS3Request> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the Amazon S3 transfer location that you're updating.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the Amazon S3 transfer location that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the bucket is
         * a source or destination location).
         * </p>
         * <note>
         * <p>
         * DataSync can't transfer objects with a prefix that begins with a slash (<code>/</code>) or includes
         * <code>//</code>, <code>/./</code>, or <code>/../</code> patterns. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>/photos</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>photos//2006/January</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>photos/./2006/February</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>photos/../2006/March</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param subdirectory
         *        Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the
         *        bucket is a source or destination location).</p> <note>
         *        <p>
         *        DataSync can't transfer objects with a prefix that begins with a slash (<code>/</code>) or includes
         *        <code>//</code>, <code>/./</code>, or <code>/../</code> patterns. For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>/photos</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>photos//2006/January</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>photos/./2006/February</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>photos/../2006/March</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
         * </p>
         * <p>
         * For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For buckets
         * on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         * >Storage class considerations with Amazon S3 transfers</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        Specifies the storage class that you want your objects to use when Amazon S3 is a transfer
         *        destination.</p>
         *        <p>
         *        For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For
         *        buckets on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         *        >Storage class considerations with Amazon S3 transfers</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(String s3StorageClass);

        /**
         * <p>
         * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
         * </p>
         * <p>
         * For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For buckets
         * on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         * >Storage class considerations with Amazon S3 transfers</a>.
         * </p>
         * 
         * @param s3StorageClass
         *        Specifies the storage class that you want your objects to use when Amazon S3 is a transfer
         *        destination.</p>
         *        <p>
         *        For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For
         *        buckets on Outposts, the storage class defaults to <code>OUTPOSTS</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes"
         *        >Storage class considerations with Amazon S3 transfers</a>.
         * @see S3StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3StorageClass
         */
        Builder s3StorageClass(S3StorageClass s3StorageClass);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * @param s3Config
         *        The new value for the S3Config property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * Sets the value of the S3Config property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private String subdirectory;

        private String s3StorageClass;

        private S3Config s3Config;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationS3Request model) {
            super(model);
            locationArn(model.locationArn);
            subdirectory(model.subdirectory);
            s3StorageClass(model.s3StorageClass);
            s3Config(model.s3Config);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getS3StorageClass() {
            return s3StorageClass;
        }

        public final void setS3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
        }

        @Override
        public final Builder s3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        public final Builder s3StorageClass(S3StorageClass s3StorageClass) {
            this.s3StorageClass(s3StorageClass == null ? null : s3StorageClass.toString());
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationS3Request build() {
            return new UpdateLocationS3Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
