/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationNfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationNfsRequest.Builder, UpdateLocationNfsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationNfsRequest::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationNfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerHostname").getter(getter(UpdateLocationNfsRequest::serverHostname))
            .setter(setter(Builder::serverHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()).build();

    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.<OnPremConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OnPremConfig").getter(getter(UpdateLocationNfsRequest::onPremConfig))
            .setter(setter(Builder::onPremConfig)).constructor(OnPremConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()).build();

    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(UpdateLocationNfsRequest::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SUBDIRECTORY_FIELD, SERVER_HOSTNAME_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String subdirectory;

    private final String serverHostname;

    private final OnPremConfig onPremConfig;

    private final NfsMountOptions mountOptions;

    private UpdateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.serverHostname = builder.serverHostname;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies the export path in your NFS file server that you want DataSync to mount.
     * </p>
     * <p>
     * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
     * configuring an export for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing NFS
     * file servers</a>.
     * </p>
     * 
     * @return Specifies the export path in your NFS file server that you want DataSync to mount.</p>
     *         <p>
     *         This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
     *         configuring an export for DataSync, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs"
     *         >Accessing NFS file servers</a>.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent connects to.
     * </p>
     * 
     * @return Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent
     *         connects to.
     */
    public final String serverHostname() {
        return serverHostname;
    }

    /**
     * Returns the value of the OnPremConfig property for this object.
     * 
     * @return The value of the OnPremConfig property for this object.
     */
    public final OnPremConfig onPremConfig() {
        return onPremConfig;
    }

    /**
     * Returns the value of the MountOptions property for this object.
     * 
     * @return The value of the MountOptions property for this object.
     */
    public final NfsMountOptions mountOptions() {
        return mountOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationNfsRequest)) {
            return false;
        }
        UpdateLocationNfsRequest other = (UpdateLocationNfsRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(serverHostname(), other.serverHostname())
                && Objects.equals(onPremConfig(), other.onPremConfig()) && Objects.equals(mountOptions(), other.mountOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationNfsRequest").add("LocationArn", locationArn()).add("Subdirectory", subdirectory())
                .add("ServerHostname", serverHostname()).add("OnPremConfig", onPremConfig()).add("MountOptions", mountOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "ServerHostname":
            return Optional.ofNullable(clazz.cast(serverHostname()));
        case "OnPremConfig":
            return Optional.ofNullable(clazz.cast(onPremConfig()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("ServerHostname", SERVER_HOSTNAME_FIELD);
        map.put("OnPremConfig", ON_PREM_CONFIG_FIELD);
        map.put("MountOptions", MOUNT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationNfsRequest, T> g) {
        return obj -> g.apply((UpdateLocationNfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationNfsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies the export path in your NFS file server that you want DataSync to mount.
         * </p>
         * <p>
         * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
         * configuring an export for DataSync, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing
         * NFS file servers</a>.
         * </p>
         * 
         * @param subdirectory
         *        Specifies the export path in your NFS file server that you want DataSync to mount.</p>
         *        <p>
         *        This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information
         *        on configuring an export for DataSync, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs"
         *        >Accessing NFS file servers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent connects
         * to.
         * </p>
         * 
         * @param serverHostname
         *        Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent
         *        connects to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverHostname(String serverHostname);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * @param onPremConfig
         *        The new value for the OnPremConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremConfig(OnPremConfig onPremConfig);

        /**
         * Sets the value of the OnPremConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OnPremConfig.Builder} avoiding the need
         * to create one manually via {@link OnPremConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremConfig(OnPremConfig)}.
         * 
         * @param onPremConfig
         *        a consumer that will call methods on {@link OnPremConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremConfig(OnPremConfig)
         */
        default Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return onPremConfig(OnPremConfig.builder().applyMutation(onPremConfig).build());
        }

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * @param mountOptions
         *        The new value for the MountOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * Sets the value of the MountOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NfsMountOptions.Builder} avoiding the
         * need to create one manually via {@link NfsMountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private String subdirectory;

        private String serverHostname;

        private OnPremConfig onPremConfig;

        private NfsMountOptions mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationNfsRequest model) {
            super(model);
            locationArn(model.locationArn);
            subdirectory(model.subdirectory);
            serverHostname(model.serverHostname);
            onPremConfig(model.onPremConfig);
            mountOptions(model.mountOptions);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getServerHostname() {
            return serverHostname;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return onPremConfig != null ? onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationNfsRequest build() {
            return new UpdateLocationNfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
