/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single entry in a list of DataSync task executions that's returned with the <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html">ListTaskExecutions</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskExecutionListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskExecutionListEntry.Builder, TaskExecutionListEntry> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskExecutionArn").getter(getter(TaskExecutionListEntry::taskExecutionArn))
            .setter(setter(Builder::taskExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TaskExecutionListEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TASK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskMode").getter(getter(TaskExecutionListEntry::taskModeAsString)).setter(setter(Builder::taskMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD,
            STATUS_FIELD, TASK_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String taskExecutionArn;

    private final String status;

    private final String taskMode;

    private TaskExecutionListEntry(BuilderImpl builder) {
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.taskMode = builder.taskMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a task execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a task execution.
     */
    public final String taskExecutionArn() {
        return taskExecutionArn;
    }

    /**
     * <p>
     * The status of a task execution. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a task execution. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
     *         >Task execution statuses</a>.
     * @see TaskExecutionStatus
     */
    public final TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a task execution. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a task execution. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
     *         >Task execution statuses</a>.
     * @see TaskExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The task mode that you're using. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for
     * your data transfer</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskMode} will
     * return {@link TaskMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskModeAsString}.
     * </p>
     * 
     * @return The task mode that you're using. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode
     *         for your data transfer</a>.
     * @see TaskMode
     */
    public final TaskMode taskMode() {
        return TaskMode.fromValue(taskMode);
    }

    /**
     * <p>
     * The task mode that you're using. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for
     * your data transfer</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskMode} will
     * return {@link TaskMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskModeAsString}.
     * </p>
     * 
     * @return The task mode that you're using. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode
     *         for your data transfer</a>.
     * @see TaskMode
     */
    public final String taskModeAsString() {
        return taskMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionListEntry)) {
            return false;
        }
        TaskExecutionListEntry other = (TaskExecutionListEntry) obj;
        return Objects.equals(taskExecutionArn(), other.taskExecutionArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(taskModeAsString(), other.taskModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskExecutionListEntry").add("TaskExecutionArn", taskExecutionArn())
                .add("Status", statusAsString()).add("TaskMode", taskModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutionArn":
            return Optional.ofNullable(clazz.cast(taskExecutionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TaskMode":
            return Optional.ofNullable(clazz.cast(taskModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskExecutionArn", TASK_EXECUTION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TaskMode", TASK_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionListEntry, T> g) {
        return obj -> g.apply((TaskExecutionListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskExecutionListEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a task execution.
         * </p>
         * 
         * @param taskExecutionArn
         *        The Amazon Resource Name (ARN) of a task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionArn(String taskExecutionArn);

        /**
         * <p>
         * The status of a task execution. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses">Task
         * execution statuses</a>.
         * </p>
         * 
         * @param status
         *        The status of a task execution. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
         *        >Task execution statuses</a>.
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a task execution. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses">Task
         * execution statuses</a>.
         * </p>
         * 
         * @param status
         *        The status of a task execution. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses"
         *        >Task execution statuses</a>.
         * @see TaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskExecutionStatus
         */
        Builder status(TaskExecutionStatus status);

        /**
         * <p>
         * The task mode that you're using. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for
         * your data transfer</a>.
         * </p>
         * 
         * @param taskMode
         *        The task mode that you're using. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task
         *        mode for your data transfer</a>.
         * @see TaskMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskMode
         */
        Builder taskMode(String taskMode);

        /**
         * <p>
         * The task mode that you're using. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for
         * your data transfer</a>.
         * </p>
         * 
         * @param taskMode
         *        The task mode that you're using. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task
         *        mode for your data transfer</a>.
         * @see TaskMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskMode
         */
        Builder taskMode(TaskMode taskMode);
    }

    static final class BuilderImpl implements Builder {
        private String taskExecutionArn;

        private String status;

        private String taskMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionListEntry model) {
            taskExecutionArn(model.taskExecutionArn);
            status(model.status);
            taskMode(model.taskMode);
        }

        public final String getTaskExecutionArn() {
            return taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTaskMode() {
            return taskMode;
        }

        public final void setTaskMode(String taskMode) {
            this.taskMode = taskMode;
        }

        @Override
        public final Builder taskMode(String taskMode) {
            this.taskMode = taskMode;
            return this;
        }

        @Override
        public final Builder taskMode(TaskMode taskMode) {
            this.taskMode(taskMode == null ? null : taskMode.toString());
            return this;
        }

        @Override
        public TaskExecutionListEntry build() {
            return new TaskExecutionListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
