/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy
 * settings configured on the Hadoop Distributed File System (HDFS) cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QopConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QopConfiguration.Builder, QopConfiguration> {
    private static final SdkField<String> RPC_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RpcProtection").getter(getter(QopConfiguration::rpcProtectionAsString))
            .setter(setter(Builder::rpcProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RpcProtection").build()).build();

    private static final SdkField<String> DATA_TRANSFER_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTransferProtection").getter(getter(QopConfiguration::dataTransferProtectionAsString))
            .setter(setter(Builder::dataTransferProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RPC_PROTECTION_FIELD,
            DATA_TRANSFER_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String rpcProtection;

    private final String dataTransferProtection;

    private QopConfiguration(BuilderImpl builder) {
        this.rpcProtection = builder.rpcProtection;
        this.dataTransferProtection = builder.dataTransferProtection;
    }

    /**
     * <p>
     * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
     * <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rpcProtection}
     * will return {@link HdfsRpcProtection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rpcProtectionAsString}.
     * </p>
     * 
     * @return The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
     *         <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop
     *         cluster.
     * @see HdfsRpcProtection
     */
    public final HdfsRpcProtection rpcProtection() {
        return HdfsRpcProtection.fromValue(rpcProtection);
    }

    /**
     * <p>
     * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
     * <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rpcProtection}
     * will return {@link HdfsRpcProtection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rpcProtectionAsString}.
     * </p>
     * 
     * @return The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
     *         <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop
     *         cluster.
     * @see HdfsRpcProtection
     */
    public final String rpcProtectionAsString() {
        return rpcProtection;
    }

    /**
     * <p>
     * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
     * <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataTransferProtection} will return {@link HdfsDataTransferProtection#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataTransferProtectionAsString}.
     * </p>
     * 
     * @return The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
     *         <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop
     *         cluster.
     * @see HdfsDataTransferProtection
     */
    public final HdfsDataTransferProtection dataTransferProtection() {
        return HdfsDataTransferProtection.fromValue(dataTransferProtection);
    }

    /**
     * <p>
     * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
     * <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataTransferProtection} will return {@link HdfsDataTransferProtection#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataTransferProtectionAsString}.
     * </p>
     * 
     * @return The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
     *         <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop
     *         cluster.
     * @see HdfsDataTransferProtection
     */
    public final String dataTransferProtectionAsString() {
        return dataTransferProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rpcProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferProtectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QopConfiguration)) {
            return false;
        }
        QopConfiguration other = (QopConfiguration) obj;
        return Objects.equals(rpcProtectionAsString(), other.rpcProtectionAsString())
                && Objects.equals(dataTransferProtectionAsString(), other.dataTransferProtectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QopConfiguration").add("RpcProtection", rpcProtectionAsString())
                .add("DataTransferProtection", dataTransferProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RpcProtection":
            return Optional.ofNullable(clazz.cast(rpcProtectionAsString()));
        case "DataTransferProtection":
            return Optional.ofNullable(clazz.cast(dataTransferProtectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RpcProtection", RPC_PROTECTION_FIELD);
        map.put("DataTransferProtection", DATA_TRANSFER_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QopConfiguration, T> g) {
        return obj -> g.apply((QopConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QopConfiguration> {
        /**
         * <p>
         * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
         * <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.
         * </p>
         * 
         * @param rpcProtection
         *        The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
         *        <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop
         *        cluster.
         * @see HdfsRpcProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsRpcProtection
         */
        Builder rpcProtection(String rpcProtection);

        /**
         * <p>
         * The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
         * <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.
         * </p>
         * 
         * @param rpcProtection
         *        The RPC protection setting configured on the HDFS cluster. This setting corresponds to your
         *        <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop
         *        cluster.
         * @see HdfsRpcProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsRpcProtection
         */
        Builder rpcProtection(HdfsRpcProtection rpcProtection);

        /**
         * <p>
         * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
         * <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop
         * cluster.
         * </p>
         * 
         * @param dataTransferProtection
         *        The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
         *        <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your
         *        Hadoop cluster.
         * @see HdfsDataTransferProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsDataTransferProtection
         */
        Builder dataTransferProtection(String dataTransferProtection);

        /**
         * <p>
         * The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
         * <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop
         * cluster.
         * </p>
         * 
         * @param dataTransferProtection
         *        The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your
         *        <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your
         *        Hadoop cluster.
         * @see HdfsDataTransferProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsDataTransferProtection
         */
        Builder dataTransferProtection(HdfsDataTransferProtection dataTransferProtection);
    }

    static final class BuilderImpl implements Builder {
        private String rpcProtection;

        private String dataTransferProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(QopConfiguration model) {
            rpcProtection(model.rpcProtection);
            dataTransferProtection(model.dataTransferProtection);
        }

        public final String getRpcProtection() {
            return rpcProtection;
        }

        public final void setRpcProtection(String rpcProtection) {
            this.rpcProtection = rpcProtection;
        }

        @Override
        public final Builder rpcProtection(String rpcProtection) {
            this.rpcProtection = rpcProtection;
            return this;
        }

        @Override
        public final Builder rpcProtection(HdfsRpcProtection rpcProtection) {
            this.rpcProtection(rpcProtection == null ? null : rpcProtection.toString());
            return this;
        }

        public final String getDataTransferProtection() {
            return dataTransferProtection;
        }

        public final void setDataTransferProtection(String dataTransferProtection) {
            this.dataTransferProtection = dataTransferProtection;
        }

        @Override
        public final Builder dataTransferProtection(String dataTransferProtection) {
            this.dataTransferProtection = dataTransferProtection;
            return this;
        }

        @Override
        public final Builder dataTransferProtection(HdfsDataTransferProtection dataTransferProtection) {
            this.dataTransferProtection(dataTransferProtection == null ? null : dataTransferProtection.toString());
            return this;
        }

        @Override
        public QopConfiguration build() {
            return new QopConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
