/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for a DataSync-managed secret, such as an authentication token or secret key that
 * DataSync uses to access a specific storage location, with a customer-managed KMS key.
 * </p>
 * <note>
 * <p>
 * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a
 * <code>CreateLocation</code> request. Do not provide both parameters for the same request.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmkSecretConfig implements SdkPojo, Serializable, ToCopyableBuilder<CmkSecretConfig.Builder, CmkSecretConfig> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(CmkSecretConfig::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CmkSecretConfig::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String kmsKeyArn;

    private CmkSecretConfig(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * Specifies the ARN for the DataSync-managed Secrets Manager secret that that is used to access a specific storage
     * location. This property is generated by DataSync and is read-only. DataSync encrypts this secret with the KMS key
     * that you specify for <code>KmsKeyArn</code>.
     * </p>
     * 
     * @return Specifies the ARN for the DataSync-managed Secrets Manager secret that that is used to access a specific
     *         storage location. This property is generated by DataSync and is read-only. DataSync encrypts this secret
     *         with the KMS key that you specify for <code>KmsKeyArn</code>.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * Specifies the ARN for the customer-managed KMS key that DataSync uses to encrypt the DataSync-managed secret
     * stored for <code>SecretArn</code>. DataSync provides this key to Secrets Manager.
     * </p>
     * 
     * @return Specifies the ARN for the customer-managed KMS key that DataSync uses to encrypt the DataSync-managed
     *         secret stored for <code>SecretArn</code>. DataSync provides this key to Secrets Manager.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmkSecretConfig)) {
            return false;
        }
        CmkSecretConfig other = (CmkSecretConfig) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmkSecretConfig").add("SecretArn", secretArn()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CmkSecretConfig, T> g) {
        return obj -> g.apply((CmkSecretConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmkSecretConfig> {
        /**
         * <p>
         * Specifies the ARN for the DataSync-managed Secrets Manager secret that that is used to access a specific
         * storage location. This property is generated by DataSync and is read-only. DataSync encrypts this secret with
         * the KMS key that you specify for <code>KmsKeyArn</code>.
         * </p>
         * 
         * @param secretArn
         *        Specifies the ARN for the DataSync-managed Secrets Manager secret that that is used to access a
         *        specific storage location. This property is generated by DataSync and is read-only. DataSync encrypts
         *        this secret with the KMS key that you specify for <code>KmsKeyArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Specifies the ARN for the customer-managed KMS key that DataSync uses to encrypt the DataSync-managed secret
         * stored for <code>SecretArn</code>. DataSync provides this key to Secrets Manager.
         * </p>
         * 
         * @param kmsKeyArn
         *        Specifies the ARN for the customer-managed KMS key that DataSync uses to encrypt the DataSync-managed
         *        secret stored for <code>SecretArn</code>. DataSync provides this key to Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CmkSecretConfig model) {
            secretArn(model.secretArn);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public CmkSecretConfig build() {
            return new CmkSecretConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
