/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.HdfsNameNode;

final class HdfsNameNodeListCopier {
    HdfsNameNodeListCopier() {
    }

    static List<HdfsNameNode> copy(Collection<? extends HdfsNameNode> hdfsNameNodeListParam) {
        Object list;
        if (hdfsNameNodeListParam == null || hdfsNameNodeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(hdfsNameNodeListParam.size());
            hdfsNameNodeListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<HdfsNameNode> copyFromBuilder(Collection<? extends HdfsNameNode.Builder> hdfsNameNodeListParam) {
        Object list;
        if (hdfsNameNodeListParam == null || hdfsNameNodeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(hdfsNameNodeListParam.size());
            hdfsNameNodeListParam.forEach(entry -> {
                HdfsNameNode member = entry == null ? null : (HdfsNameNode)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<HdfsNameNode.Builder> copyToBuilder(Collection<? extends HdfsNameNode> hdfsNameNodeListParam) {
        Object list;
        if (hdfsNameNodeListParam == null || hdfsNameNodeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(hdfsNameNodeListParam.size());
            hdfsNameNodeListParam.forEach(entry -> {
                HdfsNameNode.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

