/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationObjectStorageRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationObjectStorageRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::locationArn)).setter(UpdateLocationObjectStorageRequest.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServerPort").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::serverPort)).setter(UpdateLocationObjectStorageRequest.setter(Builder::serverPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()}).build();
    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerProtocol").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::serverProtocolAsString)).setter(UpdateLocationObjectStorageRequest.setter(Builder::serverProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::subdirectory)).setter(UpdateLocationObjectStorageRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerHostname").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::serverHostname)).setter(UpdateLocationObjectStorageRequest.setter(Builder::serverHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()}).build();
    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKey").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::accessKey)).setter(UpdateLocationObjectStorageRequest.setter(Builder::accessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()}).build();
    private static final SdkField<String> SECRET_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretKey").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::secretKey)).setter(UpdateLocationObjectStorageRequest.setter(Builder::secretKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretKey").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::agentArns)).setter(UpdateLocationObjectStorageRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SdkBytes> SERVER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ServerCertificate").getter(UpdateLocationObjectStorageRequest.getter(UpdateLocationObjectStorageRequest::serverCertificate)).setter(UpdateLocationObjectStorageRequest.setter(Builder::serverCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, SERVER_PORT_FIELD, SERVER_PROTOCOL_FIELD, SUBDIRECTORY_FIELD, SERVER_HOSTNAME_FIELD, ACCESS_KEY_FIELD, SECRET_KEY_FIELD, AGENT_ARNS_FIELD, SERVER_CERTIFICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLocationObjectStorageRequest.memberNameToFieldInitializer();
    private final String locationArn;
    private final Integer serverPort;
    private final String serverProtocol;
    private final String subdirectory;
    private final String serverHostname;
    private final String accessKey;
    private final String secretKey;
    private final List<String> agentArns;
    private final SdkBytes serverCertificate;

    private UpdateLocationObjectStorageRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.serverPort = builder.serverPort;
        this.serverProtocol = builder.serverProtocol;
        this.subdirectory = builder.subdirectory;
        this.serverHostname = builder.serverHostname;
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.agentArns = builder.agentArns;
        this.serverCertificate = builder.serverCertificate;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final Integer serverPort() {
        return this.serverPort;
    }

    public final ObjectStorageServerProtocol serverProtocol() {
        return ObjectStorageServerProtocol.fromValue(this.serverProtocol);
    }

    public final String serverProtocolAsString() {
        return this.serverProtocol;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final String serverHostname() {
        return this.serverHostname;
    }

    public final String accessKey() {
        return this.accessKey;
    }

    public final String secretKey() {
        return this.secretKey;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final SdkBytes serverCertificate() {
        return this.serverCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationObjectStorageRequest)) {
            return false;
        }
        UpdateLocationObjectStorageRequest other = (UpdateLocationObjectStorageRequest)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.serverPort(), other.serverPort()) && Objects.equals(this.serverProtocolAsString(), other.serverProtocolAsString()) && Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.serverHostname(), other.serverHostname()) && Objects.equals(this.accessKey(), other.accessKey()) && Objects.equals(this.secretKey(), other.secretKey()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.serverCertificate(), other.serverCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationObjectStorageRequest").add("LocationArn", (Object)this.locationArn()).add("ServerPort", (Object)this.serverPort()).add("ServerProtocol", (Object)this.serverProtocolAsString()).add("Subdirectory", (Object)this.subdirectory()).add("ServerHostname", (Object)this.serverHostname()).add("AccessKey", (Object)this.accessKey()).add("SecretKey", (Object)(this.secretKey() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("ServerCertificate", (Object)this.serverCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "ServerPort": {
                return Optional.ofNullable(clazz.cast(this.serverPort()));
            }
            case "ServerProtocol": {
                return Optional.ofNullable(clazz.cast(this.serverProtocolAsString()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "ServerHostname": {
                return Optional.ofNullable(clazz.cast(this.serverHostname()));
            }
            case "AccessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
            case "SecretKey": {
                return Optional.ofNullable(clazz.cast(this.secretKey()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "ServerCertificate": {
                return Optional.ofNullable(clazz.cast(this.serverCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("ServerPort", SERVER_PORT_FIELD);
        map.put("ServerProtocol", SERVER_PROTOCOL_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("ServerHostname", SERVER_HOSTNAME_FIELD);
        map.put("AccessKey", ACCESS_KEY_FIELD);
        map.put("SecretKey", SECRET_KEY_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("ServerCertificate", SERVER_CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationObjectStorageRequest, T> g) {
        return obj -> g.apply((UpdateLocationObjectStorageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private Integer serverPort;
        private String serverProtocol;
        private String subdirectory;
        private String serverHostname;
        private String accessKey;
        private String secretKey;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private SdkBytes serverCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationObjectStorageRequest model) {
            super(model);
            this.locationArn(model.locationArn);
            this.serverPort(model.serverPort);
            this.serverProtocol(model.serverProtocol);
            this.subdirectory(model.subdirectory);
            this.serverHostname(model.serverHostname);
            this.accessKey(model.accessKey);
            this.secretKey(model.secretKey);
            this.agentArns(model.agentArns);
            this.serverCertificate(model.serverCertificate);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final Integer getServerPort() {
            return this.serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final String getServerProtocol() {
            return this.serverProtocol;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ObjectStorageServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getServerHostname() {
            return this.serverHostname;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final String getAccessKey() {
            return this.accessKey;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final String getSecretKey() {
            return this.secretKey;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final ByteBuffer getServerCertificate() {
            return this.serverCertificate == null ? null : this.serverCertificate.asByteBuffer();
        }

        public final void setServerCertificate(ByteBuffer serverCertificate) {
            this.serverCertificate(serverCertificate == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)serverCertificate));
        }

        @Override
        public final Builder serverCertificate(SdkBytes serverCertificate) {
            this.serverCertificate = serverCertificate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationObjectStorageRequest build() {
            return new UpdateLocationObjectStorageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationObjectStorageRequest> {
        public Builder locationArn(String var1);

        public Builder serverPort(Integer var1);

        public Builder serverProtocol(String var1);

        public Builder serverProtocol(ObjectStorageServerProtocol var1);

        public Builder subdirectory(String var1);

        public Builder serverHostname(String var1);

        public Builder accessKey(String var1);

        public Builder secretKey(String var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder serverCertificate(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

