/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.TaskMode;
import software.amazon.awssdk.services.datasync.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskListEntry> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(TaskListEntry.getter(TaskListEntry::taskArn)).setter(TaskListEntry.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TaskListEntry.getter(TaskListEntry::statusAsString)).setter(TaskListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TaskListEntry.getter(TaskListEntry::name)).setter(TaskListEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TASK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskMode").getter(TaskListEntry.getter(TaskListEntry::taskModeAsString)).setter(TaskListEntry.setter(Builder::taskMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, STATUS_FIELD, NAME_FIELD, TASK_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskArn;
    private final String status;
    private final String name;
    private final String taskMode;

    private TaskListEntry(BuilderImpl builder) {
        this.taskArn = builder.taskArn;
        this.status = builder.status;
        this.name = builder.name;
        this.taskMode = builder.taskMode;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final TaskMode taskMode() {
        return TaskMode.fromValue(this.taskMode);
    }

    public final String taskModeAsString() {
        return this.taskMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskListEntry)) {
            return false;
        }
        TaskListEntry other = (TaskListEntry)obj;
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.taskModeAsString(), other.taskModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TaskListEntry").add("TaskArn", (Object)this.taskArn()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("TaskMode", (Object)this.taskModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TaskMode": {
                return Optional.ofNullable(clazz.cast(this.taskModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TaskMode", TASK_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskListEntry, T> g) {
        return obj -> g.apply((TaskListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskArn;
        private String status;
        private String name;
        private String taskMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskListEntry model) {
            this.taskArn(model.taskArn);
            this.status(model.status);
            this.name(model.name);
            this.taskMode(model.taskMode);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTaskMode() {
            return this.taskMode;
        }

        public final void setTaskMode(String taskMode) {
            this.taskMode = taskMode;
        }

        @Override
        public final Builder taskMode(String taskMode) {
            this.taskMode = taskMode;
            return this;
        }

        @Override
        public final Builder taskMode(TaskMode taskMode) {
            this.taskMode(taskMode == null ? null : taskMode.toString());
            return this;
        }

        public TaskListEntry build() {
            return new TaskListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskListEntry> {
        public Builder taskArn(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder name(String var1);

        public Builder taskMode(String var1);

        public Builder taskMode(TaskMode var1);
    }
}

