/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.IOPS;
import software.amazon.awssdk.services.datasync.model.Latency;
import software.amazon.awssdk.services.datasync.model.Throughput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class P95Metrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, P95Metrics> {
    private static final SdkField<IOPS> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IOPS").getter(P95Metrics.getter(P95Metrics::iops)).setter(P95Metrics.setter(Builder::iops)).constructor(IOPS::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOPS").build()}).build();
    private static final SdkField<Throughput> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Throughput").getter(P95Metrics.getter(P95Metrics::throughput)).setter(P95Metrics.setter(Builder::throughput)).constructor(Throughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()}).build();
    private static final SdkField<Latency> LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Latency").getter(P95Metrics.getter(P95Metrics::latency)).setter(P95Metrics.setter(Builder::latency)).constructor(Latency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD, LATENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = P95Metrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IOPS iops;
    private final Throughput throughput;
    private final Latency latency;

    private P95Metrics(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.latency = builder.latency;
    }

    public final IOPS iops() {
        return this.iops;
    }

    public final Throughput throughput() {
        return this.throughput;
    }

    public final Latency latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P95Metrics)) {
            return false;
        }
        P95Metrics other = (P95Metrics)obj;
        return Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.latency(), other.latency());
    }

    public final String toString() {
        return ToString.builder((String)"P95Metrics").add("IOPS", (Object)this.iops()).add("Throughput", (Object)this.throughput()).add("Latency", (Object)this.latency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IOPS": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "Latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IOPS", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("Latency", LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<P95Metrics, T> g) {
        return obj -> g.apply((P95Metrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IOPS iops;
        private Throughput throughput;
        private Latency latency;

        private BuilderImpl() {
        }

        private BuilderImpl(P95Metrics model) {
            this.iops(model.iops);
            this.throughput(model.throughput);
            this.latency(model.latency);
        }

        public final IOPS.Builder getIops() {
            return this.iops != null ? this.iops.toBuilder() : null;
        }

        public final void setIops(IOPS.BuilderImpl iops) {
            this.iops = iops != null ? iops.build() : null;
        }

        @Override
        public final Builder iops(IOPS iops) {
            this.iops = iops;
            return this;
        }

        public final Throughput.Builder getThroughput() {
            return this.throughput != null ? this.throughput.toBuilder() : null;
        }

        public final void setThroughput(Throughput.BuilderImpl throughput) {
            this.throughput = throughput != null ? throughput.build() : null;
        }

        @Override
        public final Builder throughput(Throughput throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Latency.Builder getLatency() {
            return this.latency != null ? this.latency.toBuilder() : null;
        }

        public final void setLatency(Latency.BuilderImpl latency) {
            this.latency = latency != null ? latency.build() : null;
        }

        @Override
        public final Builder latency(Latency latency) {
            this.latency = latency;
            return this;
        }

        public P95Metrics build() {
            return new P95Metrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, P95Metrics> {
        public Builder iops(IOPS var1);

        default public Builder iops(Consumer<IOPS.Builder> iops) {
            return this.iops((IOPS)((IOPS.Builder)IOPS.builder().applyMutation(iops)).build());
        }

        public Builder throughput(Throughput var1);

        default public Builder throughput(Consumer<Throughput.Builder> throughput) {
            return this.throughput((Throughput)((Throughput.Builder)Throughput.builder().applyMutation(throughput)).build());
        }

        public Builder latency(Latency var1);

        default public Builder latency(Consumer<Latency.Builder> latency) {
            return this.latency((Latency)((Latency.Builder)Latency.builder().applyMutation(latency)).build());
        }
    }
}

