/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTaskExecutionRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, StartTaskExecutionRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::taskArn)).setter(StartTaskExecutionRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Options> OVERRIDE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::overrideOptions)).setter(StartTaskExecutionRequest.setter(Builder::overrideOptions)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OVERRIDE_OPTIONS_FIELD));
    private final String taskArn;
    private final Options overrideOptions;

    private StartTaskExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.overrideOptions = builder.overrideOptions;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public Options overrideOptions() {
        return this.overrideOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionRequest)) {
            return false;
        }
        StartTaskExecutionRequest other = (StartTaskExecutionRequest)((Object)obj);
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.overrideOptions(), other.overrideOptions());
    }

    public String toString() {
        return ToString.builder((String)"StartTaskExecutionRequest").add("TaskArn", (Object)this.taskArn()).add("OverrideOptions", (Object)this.overrideOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "OverrideOptions": {
                return Optional.ofNullable(clazz.cast(this.overrideOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskExecutionRequest, T> g) {
        return obj -> g.apply((StartTaskExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String taskArn;
        private Options overrideOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskExecutionRequest model) {
            super(model);
            this.taskArn(model.taskArn);
            this.overrideOptions(model.overrideOptions);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Options.Builder getOverrideOptions() {
            return this.overrideOptions != null ? this.overrideOptions.toBuilder() : null;
        }

        @Override
        public final Builder overrideOptions(Options overrideOptions) {
            this.overrideOptions = overrideOptions;
            return this;
        }

        public final void setOverrideOptions(Options.BuilderImpl overrideOptions) {
            this.overrideOptions = overrideOptions != null ? overrideOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskExecutionRequest build() {
            return new StartTaskExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTaskExecutionRequest> {
        public Builder taskArn(String var1);

        public Builder overrideOptions(Options var1);

        default public Builder overrideOptions(Consumer<Options.Builder> overrideOptions) {
            return this.overrideOptions((Options)((Options.Builder)Options.builder().applyMutation(overrideOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

