/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.Credentials;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.DiscoveryAgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStorageSystemRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateStorageSystemRequest> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSystemArn").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::storageSystemArn)).setter(UpdateStorageSystemRequest.setter(Builder::storageSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()}).build();
    private static final SdkField<DiscoveryServerConfiguration> SERVER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerConfiguration").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::serverConfiguration)).setter(UpdateStorageSystemRequest.setter(Builder::serverConfiguration)).constructor(DiscoveryServerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerConfiguration").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::agentArns)).setter(UpdateStorageSystemRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::name)).setter(UpdateStorageSystemRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::cloudWatchLogGroupArn)).setter(UpdateStorageSystemRequest.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(UpdateStorageSystemRequest.getter(UpdateStorageSystemRequest::credentials)).setter(UpdateStorageSystemRequest.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD, SERVER_CONFIGURATION_FIELD, AGENT_ARNS_FIELD, NAME_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StorageSystemArn", STORAGE_SYSTEM_ARN_FIELD);
            this.put("ServerConfiguration", SERVER_CONFIGURATION_FIELD);
            this.put("AgentArns", AGENT_ARNS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
            this.put("Credentials", CREDENTIALS_FIELD);
        }
    });
    private final String storageSystemArn;
    private final DiscoveryServerConfiguration serverConfiguration;
    private final List<String> agentArns;
    private final String name;
    private final String cloudWatchLogGroupArn;
    private final Credentials credentials;

    private UpdateStorageSystemRequest(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.serverConfiguration = builder.serverConfiguration;
        this.agentArns = builder.agentArns;
        this.name = builder.name;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.credentials = builder.credentials;
    }

    public final String storageSystemArn() {
        return this.storageSystemArn;
    }

    public final DiscoveryServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final String name() {
        return this.name;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageSystemRequest)) {
            return false;
        }
        UpdateStorageSystemRequest other = (UpdateStorageSystemRequest)((Object)obj);
        return Objects.equals(this.storageSystemArn(), other.storageSystemArn()) && Objects.equals(this.serverConfiguration(), other.serverConfiguration()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStorageSystemRequest").add("StorageSystemArn", (Object)this.storageSystemArn()).add("ServerConfiguration", (Object)this.serverConfiguration()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("Name", (Object)this.name()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("Credentials", (Object)this.credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageSystemArn": {
                return Optional.ofNullable(clazz.cast(this.storageSystemArn()));
            }
            case "ServerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverConfiguration()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageSystemRequest, T> g) {
        return obj -> g.apply((UpdateStorageSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String storageSystemArn;
        private DiscoveryServerConfiguration serverConfiguration;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String cloudWatchLogGroupArn;
        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageSystemRequest model) {
            super(model);
            this.storageSystemArn(model.storageSystemArn);
            this.serverConfiguration(model.serverConfiguration);
            this.agentArns(model.agentArns);
            this.name(model.name);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.credentials(model.credentials);
        }

        public final String getStorageSystemArn() {
            return this.storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final DiscoveryServerConfiguration.Builder getServerConfiguration() {
            return this.serverConfiguration != null ? this.serverConfiguration.toBuilder() : null;
        }

        public final void setServerConfiguration(DiscoveryServerConfiguration.BuilderImpl serverConfiguration) {
            this.serverConfiguration = serverConfiguration != null ? serverConfiguration.build() : null;
        }

        @Override
        public final Builder serverConfiguration(DiscoveryServerConfiguration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageSystemRequest build() {
            return new UpdateStorageSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStorageSystemRequest> {
        public Builder storageSystemArn(String var1);

        public Builder serverConfiguration(DiscoveryServerConfiguration var1);

        default public Builder serverConfiguration(Consumer<DiscoveryServerConfiguration.Builder> serverConfiguration) {
            return this.serverConfiguration((DiscoveryServerConfiguration)((DiscoveryServerConfiguration.Builder)DiscoveryServerConfiguration.builder().applyMutation(serverConfiguration)).build());
        }

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder name(String var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

